/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.signs.Template;
import org.bukkit.ChatColor;

class RendersTemplate {
    RendersTemplate() {
    }

    String[] render(Template template, Arena arena) {
        String[] lines = this.getTemplateByState(template, arena);
        String[] result = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String rendered = this.render(lines[i], arena);
            result[i] = this.truncate(rendered);
        }
        return result;
    }

    private String[] getTemplateByState(Template template, Arena arena) {
        if (arena.isRunning()) {
            return template.running;
        }
        if (arena.getPlayersInLobby().size() > 0) {
            return template.joining;
        }
        return template.idle;
    }

    private String render(String line, Arena arena) {
        String result = this.generic(line, arena);
        result = arena.isRunning() ? this.running(result, arena) : this.joining(result, arena);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)result);
    }

    private String generic(String line, Arena arena) {
        return line.replace("<arena-name>", arena.configName()).replace("<min-players>", String.valueOf(arena.getMinPlayers())).replace("<max-players>", String.valueOf(arena.getMaxPlayers()));
    }

    private String running(String line, Arena arena) {
        return line.replace("<initial-players>", String.valueOf(arena.getPlayerCount())).replace("<live-players>", String.valueOf(arena.getPlayersInArena().size())).replace("<dead-players>", String.valueOf(arena.getPlayerCount() - arena.getPlayersInArena().size())).replace("<current-wave>", String.valueOf(arena.getWaveManager().getWaveNumber())).replace("<final-wave>", String.valueOf(arena.getWaveManager().getFinalWave())).replace("<lobby-players>", "-").replace("<ready-players>", "-");
    }

    private String joining(String line, Arena arena) {
        return line.replace("<initial-players>", String.valueOf(arena.getPlayersInLobby().size())).replace("<live-players>", String.valueOf(arena.getPlayersInLobby().size())).replace("<dead-players>", "-").replace("<current-wave>", "-").replace("<lobby-players>", String.valueOf(arena.getPlayersInLobby().size())).replace("<ready-players>", String.valueOf(arena.getReadyPlayersInLobby().size()));
    }

    private String truncate(String rendered) {
        if (rendered.length() <= 15) {
            return rendered;
        }
        return rendered.substring(0, 15);
    }
}

