/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.events.ArenaEndEvent;
import com.garbagemule.MobArena.events.ArenaPlayerDeathEvent;
import com.garbagemule.MobArena.events.ArenaPlayerJoinEvent;
import com.garbagemule.MobArena.events.ArenaPlayerLeaveEvent;
import com.garbagemule.MobArena.events.ArenaPlayerReadyEvent;
import com.garbagemule.MobArena.events.ArenaStartEvent;
import com.garbagemule.MobArena.events.NewWaveEvent;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.signs.RedrawsArenaSigns;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

class RedrawsSignsOnUpdates
implements Listener {
    private final RedrawsArenaSigns redrawsArenaSigns;
    private final BukkitScheduler scheduler;
    private final MobArena plugin;

    RedrawsSignsOnUpdates(RedrawsArenaSigns redrawsArenaSigns, MobArena plugin) {
        this.redrawsArenaSigns = redrawsArenaSigns;
        this.scheduler = plugin.getServer().getScheduler();
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(ArenaPlayerJoinEvent event) {
        this.handle(event.getArena());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(ArenaPlayerLeaveEvent event) {
        this.handle(event.getArena());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(ArenaPlayerReadyEvent event) {
        this.handle(event.getArena());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(ArenaStartEvent event) {
        this.handle(event.getArena());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(NewWaveEvent event) {
        this.handle(event.getArena());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(ArenaPlayerDeathEvent event) {
        this.handle(event.getArena());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on(ArenaEndEvent event) {
        this.handle(event.getArena());
    }

    private void handle(Arena arena) {
        this.scheduler.runTask((Plugin)this.plugin, () -> this.redrawsArenaSigns.redraw(arena));
    }
}

