/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.signs.ArenaSign;
import com.garbagemule.MobArena.signs.RendersTemplate;
import com.garbagemule.MobArena.signs.SetsLines;
import com.garbagemule.MobArena.signs.SignStore;
import com.garbagemule.MobArena.signs.Template;
import com.garbagemule.MobArena.signs.TemplateStore;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;

class RedrawsArenaSigns {
    private final SignStore signStore;
    private final TemplateStore templateStore;
    private final RendersTemplate rendersTemplate;
    private final SetsLines setsSignLines;

    RedrawsArenaSigns(SignStore signStore, TemplateStore templateStore, RendersTemplate rendersTemplate, SetsLines setsSignLines) {
        this.signStore = signStore;
        this.templateStore = templateStore;
        this.rendersTemplate = rendersTemplate;
        this.setsSignLines = setsSignLines;
    }

    void redraw(Arena arena) {
        List<ArenaSign> signs = this.signStore.findByArenaId(arena.configName());
        Map<String, String[]> rendered = signs.stream().map(sign -> sign.templateId).distinct().collect(Collectors.toMap(templateId -> templateId, templateId -> this.render((String)templateId, arena)));
        signs.forEach(sign -> this.setsSignLines.set(sign.location, (String[])rendered.get(sign.templateId)));
    }

    private String[] render(String templateId, Arena arena) {
        return this.templateStore.findById(templateId).map(template -> this.rendersTemplate.render((Template)template, arena)).orElseGet(() -> RedrawsArenaSigns.notFound(templateId));
    }

    private static String[] notFound(String templateId) {
        return new String[]{String.join((CharSequence)(ChatColor.MAGIC + "b" + ChatColor.RESET), "BROKEN".split("")), "Template", ChatColor.BOLD + templateId, "not found! :("};
    }
}

