/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.signs.Template;
import com.garbagemule.MobArena.signs.TemplateStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

class LoadsTemplateStore {
    private final MobArena plugin;

    LoadsTemplateStore(MobArena plugin) {
        this.plugin = plugin;
    }

    TemplateStore read() {
        YamlConfiguration yaml = new YamlConfiguration();
        try {
            File file = new File(this.plugin.getDataFolder(), "signs.yml");
            if (!file.exists()) {
                this.plugin.getLogger().info("signs.yml not found, creating default...");
                this.plugin.saveResource("signs.yml", false);
            }
            yaml.load(file);
        }
        catch (InvalidConfigurationException e) {
            throw new IllegalStateException("signs.yml is invalid!", e);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("signs.yml is missing!", e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        HashMap<String, Template> map = new HashMap<String, Template>();
        for (String key : yaml.getKeys(false)) {
            this.validateTemplateNode(key, yaml);
            String templateId = this.stripStateSuffix(key);
            map.computeIfAbsent(templateId, id -> this.loadTemplate((String)id, yaml));
        }
        this.plugin.getLogger().info("Loaded " + map.size() + " sign templates.");
        return new TemplateStore(map);
    }

    private void validateTemplateNode(String key, YamlConfiguration yaml) {
        List list = yaml.getList(key);
        if (list == null) {
            String msg = "Template " + key + " in " + "signs.yml" + " is not a list!";
            throw new IllegalStateException(msg);
        }
        list.forEach(element -> {
            if (!(element instanceof String)) {
                String msg = "Template " + key + " in " + "signs.yml" + " is not a valid list of strings!";
                throw new IllegalStateException(msg);
            }
        });
    }

    private String stripStateSuffix(String id) {
        if (this.hasStateSuffix(id)) {
            return id.split("-", -1)[0];
        }
        return id;
    }

    private boolean hasStateSuffix(String id) {
        return id.endsWith("-idle") || id.endsWith("-joining") || id.endsWith("-running");
    }

    private Template loadTemplate(String id, YamlConfiguration yaml) {
        String[] base = this.getLines(yaml, id);
        String[] idle = this.getLines(yaml, id + "-idle");
        String[] joining = this.getLines(yaml, id + "-joining");
        String[] running = this.getLines(yaml, id + "-running");
        return new Template.Builder(id).withBase(base).withIdle(idle).withJoining(joining).withRunning(running).build();
    }

    private String[] getLines(YamlConfiguration config, String id) {
        List<String> list = config.getStringList(id);
        if (list.isEmpty()) {
            return null;
        }
        while (list.size() < 4) {
            list.add("");
        }
        if (list.size() > 4) {
            list = list.subList(0, 4);
        }
        return list.toArray(new String[0]);
    }
}

