/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.signs.ArenaSign;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class InvokesSignAction {
    private final ArenaMaster arenaMaster;
    private final Messenger messenger;

    InvokesSignAction(ArenaMaster arenaMaster, Messenger messenger) {
        this.arenaMaster = arenaMaster;
        this.messenger = messenger;
    }

    void invoke(ArenaSign sign, Player player) {
        if (sign.type.equals("join")) {
            Arena current = this.arenaMaster.getArenaWithPlayer(player);
            if (current != null) {
                if (current.inArena(player) || current.inLobby(player)) {
                    current.getMessenger().tell((CommandSender)player, Msg.JOIN_ALREADY_PLAYING);
                    return;
                }
                if (!current.playerLeave(player)) {
                    return;
                }
            }
            this.withArena(sign, player, arena -> {
                if (arena.canJoin(player)) {
                    arena.playerJoin(player, player.getLocation());
                }
            });
        } else if (sign.type.equals("leave")) {
            this.withArena(sign, player, arena -> {
                if ((arena.inArena(player) || arena.inLobby(player) || arena.inSpec(player)) && arena.playerLeave(player)) {
                    arena.getMessenger().tell((CommandSender)player, Msg.LEAVE_PLAYER_LEFT);
                }
            });
        }
    }

    private void withArena(ArenaSign sign, Player player, Consumer<Arena> action) {
        Arena arena = this.arenaMaster.getArenaWithName(sign.arenaId);
        if (arena == null) {
            this.messenger.tell((CommandSender)player, "Arena " + sign.arenaId + " not found");
            return;
        }
        action.accept(arena);
    }
}

