/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.signs.RendersTemplateById;
import com.garbagemule.MobArena.signs.StoresNewSign;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

class HandlesSignCreation
implements Listener {
    private final StoresNewSign storesNewSign;
    private final RendersTemplateById rendersTemplate;
    private final Messenger messenger;

    HandlesSignCreation(StoresNewSign storesNewSign, RendersTemplateById rendersTemplate, Messenger messenger) {
        this.storesNewSign = storesNewSign;
        this.rendersTemplate = rendersTemplate;
        this.messenger = messenger;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on(SignChangeEvent event) {
        if (!this.trim(event, 0).equalsIgnoreCase("[MA]")) {
            return;
        }
        Location location = event.getBlock().getLocation();
        String arenaId = this.trim(event, 1);
        String signType = this.trim(event, 2).toLowerCase();
        String templateId = this.trim(event, 3).toLowerCase();
        if (templateId.isEmpty()) {
            templateId = signType;
        }
        Player player = event.getPlayer();
        try {
            this.storesNewSign.store(location, arenaId, templateId, signType);
            this.messenger.tell((CommandSender)player, "New " + signType + " sign created for arena " + arenaId);
            String[] lines = this.rendersTemplate.render(templateId, arenaId);
            IntStream.range(0, 4).forEach(i -> event.setLine(i, lines[i]));
        }
        catch (IllegalArgumentException e) {
            this.messenger.tell((CommandSender)player, e.getMessage());
        }
    }

    private String trim(SignChangeEvent event, int index) {
        String line = event.getLine(index);
        if (line == null) {
            return "";
        }
        return line.trim();
    }
}

