/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.signs.ArenaSign;
import com.garbagemule.MobArena.signs.InvokesSignAction;
import com.garbagemule.MobArena.signs.SignStore;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;

class HandlesSignClicks
implements Listener {
    private static final long COOLDOWN_TIME = 500L;
    private final SignStore signStore;
    private final InvokesSignAction invokesSignAction;
    private final Map<UUID, Long> cooldowns;

    HandlesSignClicks(SignStore signStore, InvokesSignAction invokesSignAction) {
        this.signStore = signStore;
        this.invokesSignAction = invokesSignAction;
        this.cooldowns = new HashMap<UUID, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        this.signStore.findByLocation(block.getLocation()).ifPresent(sign -> this.purgeAndInvoke((ArenaSign)sign, event.getPlayer()));
    }

    private void purgeAndInvoke(ArenaSign sign, Player player) {
        long now = System.currentTimeMillis();
        this.cooldowns.values().removeIf(time -> time < now);
        this.cooldowns.computeIfAbsent(player.getUniqueId(), id -> {
            this.invokesSignAction.invoke(sign, player);
            return now + 500L;
        });
    }
}

