/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.listeners;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.enums.WaveType;
import com.nisovin.magicspells.events.SpellCastEvent;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class MagicSpellsListener
implements Listener {
    private MobArena plugin;
    private List<String> disabled;
    private List<String> disabledOnBoss;
    private List<String> disabledOnSwarm;

    public MagicSpellsListener(MobArena plugin) {
        this.plugin = plugin;
        File file = new File(plugin.getDataFolder(), "magicspells.yml");
        if (!file.exists()) {
            plugin.saveResource("magicspells.yml", false);
            plugin.getLogger().info("magicspells.yml created.");
        }
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.load(file);
            this.setupSpells((ConfigurationSection)config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onSpellCast(SpellCastEvent event) {
        WaveType type;
        Arena arena = this.plugin.getArenaMaster().getArenaWithPlayer(event.getCaster());
        if (arena == null || !arena.isRunning()) {
            return;
        }
        String spell = event.getSpell().getName();
        WaveType waveType = type = arena.getWaveManager().getCurrent() != null ? arena.getWaveManager().getCurrent().getType() : null;
        if (this.disabled.contains(spell) || type == WaveType.BOSS && this.disabledOnBoss.contains(spell) || type == WaveType.SWARM && this.disabledOnSwarm.contains(spell)) {
            event.setCancelled(true);
        }
    }

    private void setupSpells(ConfigurationSection config) {
        this.disabled = config.getStringList("disabled-spells");
        this.disabledOnBoss = config.getStringList("disabled-on-bosses");
        this.disabledOnSwarm = config.getStringList("disabled-on-swarms");
    }
}

