/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.healthbar;

import com.garbagemule.MobArena.healthbar.CreatesHealthString;
import com.garbagemule.MobArena.healthbar.HealthBar;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;

class TitleHealthBar
implements HealthBar {
    private static final int FADE_IN_TICKS = 5;
    private static final int STAY_TICKS = 40;
    private static final int FADE_OUT_TICKS = 10;
    private final String title;
    private final CreatesHealthString createsHealthString;
    private final Set<Player> players;

    TitleHealthBar(String title, CreatesHealthString createsHealthString) {
        this.title = title;
        this.createsHealthString = createsHealthString;
        this.players = new HashSet<Player>();
    }

    @Override
    public void setProgress(double progress) {
        String health = this.createsHealthString.create(progress);
        String message = this.title.isEmpty() ? health : this.title + " " + health;
        this.players.forEach(player -> player.sendTitle("", message, 5, 40, 10));
    }

    @Override
    public void addPlayer(Player player) {
        this.players.add(player);
    }

    @Override
    public void removePlayer(Player player) {
        this.players.remove(player);
    }

    @Override
    public void removeAll() {
        this.players.clear();
    }
}

