/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.config;

import com.garbagemule.MobArena.MobArena;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LoadsConfigFile {
    private final MobArena plugin;

    public LoadsConfigFile(MobArena plugin) {
        this.plugin = plugin;
    }

    public FileConfiguration load() {
        try {
            return this.loadConfiguration();
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new IllegalStateException("Failed to load config-file", e);
        }
    }

    private FileConfiguration loadConfiguration() throws IOException, InvalidConfigurationException {
        File folder = this.createDataFolder();
        File file = new File(folder, "config.yml");
        if (!file.exists()) {
            this.plugin.getLogger().info("No config-file found. Creating default...");
            this.plugin.saveDefaultConfig();
        }
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.load(file);
        return yaml;
    }

    private File createDataFolder() {
        File folder = this.plugin.getDataFolder();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IllegalStateException("Failed to create data folder");
        }
        return folder;
    }
}

