/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.user;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.commands.Commands;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandInfo(name="spec", pattern="s|spec.*", usage="/ma spec (<arena>)", desc="spec an arena", permission="mobarena.use.spec")
public class SpecCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        String arg1;
        if (!Commands.isPlayer(sender)) {
            am.getGlobalMessenger().tell(sender, Msg.MISC_NOT_FROM_CONSOLE);
            return false;
        }
        Player p = Commands.unwrap(sender);
        Arena toArena = Commands.getArenaToJoinOrSpec(am, p, arg1 = args.length > 0 ? args[0] : null);
        if (toArena == null || !this.canSpec(p, toArena)) {
            return true;
        }
        int seconds = toArena.getSettings().getInt("join-interrupt-timer", 0);
        if (seconds > 0) {
            boolean started = am.getJoinInterruptTimer().start(p, toArena, seconds, () -> this.trySpec(p, toArena));
            if (started) {
                toArena.getMessenger().tell((CommandSender)p, Msg.JOIN_AFTER_DELAY, String.valueOf(seconds));
            } else {
                toArena.getMessenger().tell((CommandSender)p, Msg.SPEC_ALREADY_PLAYING);
            }
        } else {
            this.trySpec(p, toArena);
        }
        return true;
    }

    private boolean canSpec(Player player, Arena arena) {
        MobArena plugin = arena.getPlugin();
        ArenaMaster am = plugin.getArenaMaster();
        if (am.getJoinInterruptTimer().isWaiting(player)) {
            plugin.getGlobalMessenger().tell((CommandSender)player, Msg.SPEC_ALREADY_PLAYING);
            return false;
        }
        Arena current = arena.getPlugin().getArenaMaster().getArenaWithPlayer(player);
        if (current != null) {
            current.getMessenger().tell((CommandSender)player, Msg.SPEC_ALREADY_PLAYING);
            return false;
        }
        return arena.canSpec(player);
    }

    private void trySpec(Player player, Arena arena) {
        if (this.canSpec(player, arena)) {
            arena.playerSpec(player, player.getLocation());
        }
    }

    @Override
    public List<String> tab(ArenaMaster am, Player player, String ... args) {
        if (args.length > 1) {
            return Collections.emptyList();
        }
        String prefix = args[0].toLowerCase();
        List<Arena> arenas = am.getPermittedArenas(player);
        return arenas.stream().filter(Arena::isEnabled).filter(arena -> arena.configName().toLowerCase().startsWith(prefix)).filter(arena -> arena.getRegion().isSetup()).map(Arena::configName).collect(Collectors.toList());
    }
}

