/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.user;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.ClassLimitManager;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.commands.Commands;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.util.ClassChests;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandInfo(name="class", pattern="(pick)?class", usage="/ma class <class>", desc="pick a class", permission="mobarena.use.class")
public class PickClassCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        if (!Commands.isPlayer(sender)) {
            am.getGlobalMessenger().tell(sender, Msg.MISC_NOT_FROM_CONSOLE);
            return true;
        }
        if (args.length != 1) {
            return false;
        }
        Player p = Commands.unwrap(sender);
        Arena arena = am.getArenaWithPlayer(p);
        if (arena == null) {
            return true;
        }
        if (!arena.inLobby(p)) {
            arena.getMessenger().tell((CommandSender)p, Msg.MISC_NO_ACCESS);
            return true;
        }
        String lowercase = args[0].toLowerCase();
        ArenaClass ac = am.getClasses().get(lowercase);
        if (ac == null) {
            arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_NO_SUCH_CLASS, lowercase);
            return true;
        }
        if (!ac.hasPermission(p) && !lowercase.equals("random")) {
            arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_PERMISSION);
            return true;
        }
        ArenaClass oldAC = arena.getArenaPlayer(p).getArenaClass();
        if (ac.equals(oldAC)) {
            return true;
        }
        ClassLimitManager clm = arena.getClassLimitManager();
        if (!clm.canPlayerJoinClass(ac)) {
            arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_FULL);
            return true;
        }
        Thing price = ac.getPrice();
        if (price != null && !price.heldBy(p)) {
            arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_TOO_EXPENSIVE, price.toString());
            return true;
        }
        clm.playerLeftClass(oldAC, p);
        clm.playerPickedClass(ac, p);
        if (!lowercase.equalsIgnoreCase("random")) {
            if (arena.getSettings().getBoolean("use-class-chests", false) && ClassChests.assignClassFromStoredClassChest(arena, p, ac)) {
                return true;
            }
            arena.assignClass(p, lowercase);
            arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_PICKED, arena.getClasses().get(lowercase).getConfigName());
            if (price != null) {
                arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_PRICE, price.toString());
            }
        } else {
            arena.addRandomPlayer(p);
            arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_RANDOM);
        }
        return true;
    }

    @Override
    public List<String> tab(ArenaMaster am, Player player, String ... args) {
        if (args.length > 1) {
            return Collections.emptyList();
        }
        String prefix = args[0].toLowerCase();
        Collection<ArenaClass> classes = am.getClasses().values();
        return classes.stream().filter(cls -> cls.getConfigName().toLowerCase().startsWith(prefix)).filter(cls -> cls.hasPermission(player)).map(ArenaClass::getConfigName).collect(Collectors.toList());
    }
}

