/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.user;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.commands.Commands;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandInfo(name="join", pattern="j|jo.*|j.*n", usage="/ma join (<arena>)", desc="join an arena", permission="mobarena.use.join")
public class JoinCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        String arg1;
        if (!Commands.isPlayer(sender)) {
            am.getGlobalMessenger().tell(sender, Msg.MISC_NOT_FROM_CONSOLE);
            return true;
        }
        Player p = Commands.unwrap(sender);
        Arena toArena = Commands.getArenaToJoinOrSpec(am, p, arg1 = args.length > 0 ? args[0] : null);
        if (toArena == null || !this.canJoin(p, toArena)) {
            return true;
        }
        int seconds = toArena.getSettings().getInt("join-interrupt-timer", 0);
        if (seconds > 0) {
            boolean started = am.getJoinInterruptTimer().start(p, toArena, seconds, () -> this.tryJoin(am, p, toArena));
            if (started) {
                toArena.getMessenger().tell((CommandSender)p, Msg.JOIN_AFTER_DELAY, String.valueOf(seconds));
            } else {
                toArena.getMessenger().tell((CommandSender)p, Msg.JOIN_ALREADY_PLAYING);
            }
        } else {
            this.tryJoin(am, p, toArena);
        }
        return true;
    }

    private boolean canJoin(Player player, Arena arena) {
        MobArena plugin = arena.getPlugin();
        ArenaMaster am = plugin.getArenaMaster();
        if (am.getJoinInterruptTimer().isWaiting(player)) {
            plugin.getGlobalMessenger().tell((CommandSender)player, Msg.JOIN_ALREADY_PLAYING);
            return false;
        }
        return arena.canJoin(player);
    }

    private void tryJoin(ArenaMaster am, Player player, Arena arena) {
        Arena current = am.getArenaWithPlayer(player);
        if (current != null) {
            if (current.inArena(player) || current.inLobby(player)) {
                current.getMessenger().tell((CommandSender)player, Msg.JOIN_ALREADY_PLAYING);
                return;
            }
            if (!current.playerLeave(player)) {
                return;
            }
        }
        if (this.canJoin(player, arena)) {
            arena.playerJoin(player, player.getLocation());
        }
    }

    @Override
    public List<String> tab(ArenaMaster am, Player player, String ... args) {
        if (args.length > 1) {
            return Collections.emptyList();
        }
        String prefix = args[0].toLowerCase();
        List<Arena> arenas = am.getPermittedArenas(player);
        return arenas.stream().filter(Arena::isEnabled).filter(arena -> arena.configName().toLowerCase().startsWith(prefix)).filter(arena -> arena.getRegion().isSetup()).map(Arena::configName).collect(Collectors.toList());
    }
}

