/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.setup;

import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.commands.Commands;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.region.ArenaRegion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

@CommandInfo(name="setup", pattern="setup", usage="/ma setup <arena>", desc="enter setup mode for an arena", permission="mobarena.setup.setup")
public class SetupCommand
implements Command,
Listener {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        Arena arena;
        if (!Commands.isPlayer(sender)) {
            am.getGlobalMessenger().tell(sender, Msg.MISC_NOT_FROM_CONSOLE);
            return true;
        }
        if (args.length == 0) {
            List<Arena> arenas = am.getArenas();
            if (arenas.size() > 1) {
                return false;
            }
            arena = arenas.get(0);
        } else {
            arena = am.getArenaWithName(args[0]);
            if (arena == null) {
                am.getGlobalMessenger().tell(sender, "There is no arena with the name " + ChatColor.RED + args[0] + ChatColor.RESET + ".");
                am.getGlobalMessenger().tell(sender, "Type " + ChatColor.YELLOW + "/ma addarena " + args[0] + ChatColor.RESET + " to create it!");
                return true;
            }
        }
        Player player = Commands.unwrap(sender);
        Setup setup = new Setup(player, arena);
        am.getPlugin().getServer().getPluginManager().registerEvents((Listener)setup, (Plugin)am.getPlugin());
        Conversation convo = new Conversation((Plugin)am.getPlugin(), (Conversable)player, (Prompt)setup);
        setup.convo = convo;
        convo.addConversationAbandonedListener((ConversationAbandonedListener)setup);
        convo.setLocalEchoEnabled(false);
        convo.begin();
        return true;
    }

    @Override
    public List<String> tab(ArenaMaster am, Player player, String ... args) {
        if (args.length > 1) {
            return Collections.emptyList();
        }
        String prefix = args[0].toLowerCase();
        List<Arena> arenas = am.getArenas();
        return arenas.stream().filter(arena -> arena.configName().toLowerCase().startsWith(prefix)).map(Arena::configName).collect(Collectors.toList());
    }

    private class Setup
    implements Prompt,
    ConversationAbandonedListener,
    Listener {
        private Player player;
        private Arena arena;
        private Conversation convo;
        private boolean enabled;
        private boolean allowFlight;
        private boolean flying;
        private ItemStack[] armor;
        private ItemStack[] items;
        private List<String> missing;
        private String next;
        private int warpIndex = 0;
        private String[] warpArray = new String[]{"arena", "lobby", "spectator", "exit"};
        private static final String AREG_NAME = "Arena Region";
        private static final String LREG_NAME = "Lobby Region";
        private static final String WARPS_NAME = "Warps";
        private static final String SPAWNS_NAME = "Spawnpoints";
        private static final String CHESTS_NAME = "Containers";
        private static final String MANUAL_NAME = "Manual";
        private static final String HELP = "[?]|h(elp)?";
        private static final String MISSING = "miss(ing)?";
        private static final String EXPAND = "exp(and)? (a|l)r [1-9][0-9]* (up|down|out)";
        private static final String EXPHELP = "exp(and)?";
        private static final String SHOW = "show (r|ar|lr|arena|lobby|spec(tator)?|exit|sp(awn(point)?s?)?|c((hest(s)?)?|on(tainer(s)?)?))";
        private static final String SHOWHELP = "show";
        private static final String DONE = "done|quit|stop|end";

        public Setup(Player player, Arena arena) {
            this.player = player;
            this.arena = arena;
            this.enabled = arena.isEnabled();
            this.allowFlight = player.getAllowFlight();
            this.flying = player.isFlying();
            this.armor = player.getInventory().getArmorContents();
            this.items = player.getInventory().getContents();
            arena.setEnabled(false);
            player.setAllowFlight(true);
            player.setFlying(true);
            player.getInventory().clear();
            player.getInventory().setContents(this.getToolbox());
            player.getInventory().setHeldItemSlot(0);
            this.missing = new ArrayList<String>();
            this.next = this.color(String.format("Setup Mode for arena &a%s&r. Type &e?&r for help.", "&a" + arena.configName() + "&r"));
            ArenaRegion region = arena.getRegion();
            if (!region.isSetup()) {
                if (!region.isDefined()) {
                    this.missing.add("p1");
                    this.missing.add("p2");
                }
                if (region.getArenaWarp() == null) {
                    this.missing.add("arena");
                }
                if (region.getLobbyWarp() == null) {
                    this.missing.add("lobby");
                }
                if (region.getSpecWarp() == null) {
                    this.missing.add("spectator");
                }
                if (region.getSpawnpoints().isEmpty()) {
                    this.missing.add("spawnpoints");
                }
            }
        }

        private ItemStack[] getToolbox() {
            ItemStack areg = this.makeTool(Material.GOLDEN_AXE, AREG_NAME, this.color("Set &ep1"), this.color("Set &ep2"));
            ItemStack warps = this.makeTool(Material.GOLDEN_HOE, WARPS_NAME, this.color("&eSet &rselected warp"), this.color("&eCycle &rbetween warps"));
            ItemStack spawns = this.makeTool(Material.GOLDEN_SWORD, SPAWNS_NAME, this.color("&eAdd &rspawnpoint on block"), this.color("&eRemove &rspawnpoint on block"));
            ItemStack chests = this.makeTool(Material.GOLDEN_SHOVEL, CHESTS_NAME, this.color("&eAdd &rcontainer"), this.color("&eRemove &rcontainer"));
            ItemStack lreg = this.makeTool(Material.GOLDEN_AXE, LREG_NAME, this.color("Set &el1"), this.color("Set &el2"));
            return new ItemStack[]{null, areg, warps, spawns, chests, null, lreg};
        }

        private ItemStack makeTool(Material mat, String name, String left, String right) {
            ItemStack tool = new ItemStack(mat);
            ItemMeta meta = tool.getItemMeta();
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(this.color("&9Left&r: &r" + left), this.color("&cRight&r: &r" + right)));
            meta.setUnbreakable(true);
            tool.setItemMeta(meta);
            return tool;
        }

        private boolean isTool(ItemStack item) {
            if (item == null || item.getType() == Material.AIR) {
                return false;
            }
            String name = item.getItemMeta().getDisplayName();
            if (name == null) {
                return false;
            }
            return name.equals(AREG_NAME) || name.equals(LREG_NAME) || name.equals(WARPS_NAME) || name.equals(SPAWNS_NAME) || name.equals(CHESTS_NAME) || name.equals(MANUAL_NAME);
        }

        @EventHandler
        public void onDisable(PluginDisableEvent event) {
            if (event.getPlugin().getName().equals(this.arena.getPlugin().getName()) && this.player.isConversing()) {
                this.player.abandonConversation(this.convo);
            }
        }

        @EventHandler
        public void onQuit(PlayerQuitEvent event) {
            if (event.getPlayer().equals(this.player) && this.player.isConversing()) {
                this.player.abandonConversation(this.convo);
            }
        }

        @EventHandler
        public void onBreak(BlockBreakEvent event) {
            Player p = event.getPlayer();
            if (!p.equals(this.player)) {
                return;
            }
            ItemStack tool = p.getInventory().getItemInMainHand();
            if (!this.isTool(tool)) {
                return;
            }
            event.setCancelled(true);
        }

        @EventHandler
        public void onDrop(PlayerDropItemEvent event) {
            Player p = event.getPlayer();
            if (!p.equals(this.player)) {
                return;
            }
            event.setCancelled(true);
            this.tell((Conversable)p, "You can't drop the toolbox items.");
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onInteract(PlayerInteractEvent event) {
            Player p = event.getPlayer();
            if (!p.equals(this.player)) {
                return;
            }
            if (event.getHand() == EquipmentSlot.OFF_HAND) {
                return;
            }
            ItemStack tool = p.getInventory().getItemInMainHand();
            if (!this.isTool(tool)) {
                return;
            }
            String name = tool.getItemMeta().getDisplayName();
            if (name.equals(AREG_NAME) ? !this.arena(event) : (name.equals(LREG_NAME) ? !this.lobby(event) : (name.equals(WARPS_NAME) ? !this.warps(event) : (name.equals(SPAWNS_NAME) ? !this.spawns(event) : name.equals(CHESTS_NAME) && !this.chests(event))))) {
                return;
            }
            event.setUseItemInHand(Event.Result.DENY);
            event.setCancelled(true);
            this.player.sendRawMessage(this.getPromptText(null));
        }

        private boolean arena(PlayerInteractEvent event) {
            if (!event.hasBlock()) {
                return false;
            }
            Location loc = event.getClickedBlock().getLocation();
            this.region(event.getAction(), "p1", "p2", loc);
            return true;
        }

        private boolean lobby(PlayerInteractEvent event) {
            if (!event.hasBlock()) {
                return false;
            }
            Location loc = event.getClickedBlock().getLocation();
            this.region(event.getAction(), "l1", "l2", loc);
            return true;
        }

        private boolean region(Action action, String lower, String upper, Location loc) {
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    this.regions(lower, loc);
                    return true;
                }
                case RIGHT_CLICK_BLOCK: {
                    this.regions(upper, loc);
                    return true;
                }
            }
            return false;
        }

        private boolean warps(PlayerInteractEvent event) {
            switch (event.getAction()) {
                case LEFT_CLICK_BLOCK: {
                    Location loc = event.getClickedBlock().getLocation();
                    loc.setYaw(this.player.getLocation().getYaw());
                    loc.setPitch(0.0f);
                    this.fix(loc);
                    String warp = this.warpArray[this.warpIndex];
                    this.warps(warp, loc);
                    return true;
                }
                case RIGHT_CLICK_BLOCK: 
                case RIGHT_CLICK_AIR: {
                    ++this.warpIndex;
                    if (this.warpIndex == this.warpArray.length) {
                        this.warpIndex = 0;
                    }
                    this.next = this.formatYellow("Current warp: %s", this.warpArray[this.warpIndex]);
                    return true;
                }
            }
            return false;
        }

        private boolean spawns(PlayerInteractEvent event) {
            if (!event.hasBlock()) {
                return false;
            }
            Location l = event.getClickedBlock().getLocation();
            this.fix(l);
            switch (event.getAction()) {
                case LEFT_CLICK_BLOCK: {
                    this.spawns(l, true);
                    return true;
                }
                case RIGHT_CLICK_BLOCK: {
                    this.spawns(l, false);
                    return true;
                }
            }
            return false;
        }

        private boolean chests(PlayerInteractEvent event) {
            if (!event.hasBlock()) {
                return false;
            }
            Block b = event.getClickedBlock();
            switch (event.getAction()) {
                case LEFT_CLICK_BLOCK: {
                    this.chests(b, true);
                    return true;
                }
                case RIGHT_CLICK_BLOCK: {
                    this.chests(b, false);
                    return true;
                }
            }
            return false;
        }

        private void fix(Location loc) {
            loc.setX((double)loc.getBlockX() + 0.5);
            loc.setY((double)(loc.getBlockY() + 1));
            loc.setZ((double)loc.getBlockZ() + 0.5);
        }

        public void conversationAbandoned(ConversationAbandonedEvent event) {
            HandlerList.unregisterAll((Listener)this);
            this.arena.setEnabled(this.enabled);
            this.arena.getRegion().save();
            this.arena.getRegion().reloadAll();
            this.player.getInventory().setContents(this.items);
            this.player.getInventory().setArmorContents(this.armor);
            this.player.setAllowFlight(this.allowFlight);
            if (this.allowFlight) {
                this.player.setFlying(this.flying);
            }
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.GREEN + "[MobArena] " + ChatColor.RESET + this.next;
        }

        public boolean blocksForInput(ConversationContext context) {
            return true;
        }

        public Prompt acceptInput(ConversationContext context, String s) {
            return s.matches(HELP) ? this.help() : (s.matches(MISSING) ? this.missing() : (s.matches(EXPAND) ? this.expand(s) : (s.matches(EXPHELP) ? this.expandOptions() : (s.matches(SHOW) ? this.show(context, s) : (s.matches(SHOWHELP) ? this.showOptions() : (s.matches(DONE) ? this.done() : this.invalidInput()))))));
        }

        private Prompt help() {
            StringBuilder buffy = new StringBuilder();
            buffy.append("\nAvailable input:");
            buffy.append("\n&r&e exp   &7expand a region");
            buffy.append("\n&r&e show   &7show a region, warp, or point");
            buffy.append("\n&r&e miss   &7show missing warps and points");
            buffy.append("\n&r&e done   &7exit out of Setup Mode");
            buffy.append("\n&r&7Read &bitem tooltips&r&7 for info about each tool.");
            this.next = this.color(buffy.toString());
            return this;
        }

        private Prompt regions(String s, Location loc) {
            if (!this.inArenaWorld()) {
                String msg = String.format("Changed world of arena %s from %s to %s.", ChatColor.GREEN + this.arena.configName() + ChatColor.RESET, ChatColor.YELLOW + this.arena.getWorld().getName() + ChatColor.RESET, ChatColor.YELLOW + loc.getWorld().getName() + ChatColor.RESET);
                this.arena.setWorld(loc.getWorld());
                this.tell((Conversable)this.player, msg);
            }
            this.arena.getRegion().set(s, loc);
            this.next = this.formatYellow("Region point %s was set.", s);
            this.missing.remove(s);
            return this;
        }

        private Prompt expand(String s) {
            String[] parts = s.split(" ");
            boolean lobby = parts[1].equalsIgnoreCase("lr");
            int amount = Integer.parseInt(parts[2]);
            if (parts[3].equalsIgnoreCase("up")) {
                if (lobby) {
                    this.arena.getRegion().expandLobbyUp(amount);
                } else {
                    this.arena.getRegion().expandUp(amount);
                }
            } else if (parts[3].equalsIgnoreCase("down")) {
                if (lobby) {
                    this.arena.getRegion().expandLobbyDown(amount);
                } else {
                    this.arena.getRegion().expandDown(amount);
                }
            } else if (lobby) {
                this.arena.getRegion().expandLobbyOut(amount);
            } else {
                this.arena.getRegion().expandOut(amount);
            }
            this.next = this.color(String.format("Expanded &e%s&r region &e%s&r by &e%s&r blocks.", lobby ? "lobby" : "arena", parts[3], parts[2]));
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Prompt warps(String s, Location loc) {
            if (s.equals("spec")) {
                s = "spectator";
            }
            if (s.equals("arena") && !this.arena.getRegion().contains(loc)) {
                if (this.arena.getWorld().getName().equals(loc.getWorld().getName())) {
                    this.next = "You must be inside the arena region.";
                    return this;
                }
                World tmp = this.arena.getWorld();
                this.arena.setWorld(loc.getWorld());
                if (!this.arena.getRegion().contains(loc)) {
                    this.arena.setWorld(tmp);
                    this.next = "You must be inside the arena region.";
                    return this;
                }
                String msg = String.format("Changed world of arena %s from %s to %s.", ChatColor.GREEN + this.arena.configName() + ChatColor.RESET, ChatColor.YELLOW + tmp.getName() + ChatColor.RESET, ChatColor.YELLOW + loc.getWorld().getName() + ChatColor.RESET);
                this.tell((Conversable)this.player, msg);
            }
            this.missing.remove(s);
            this.arena.getRegion().set(s, loc);
            this.next = this.formatYellow("Warp point %s was set.", s);
            return this;
        }

        private Prompt spawns(Location l, boolean add) {
            String point = this.getName(l);
            if (add) {
                if (!this.arena.getRegion().contains(l)) {
                    this.next = "You must be inside the arena region.";
                } else {
                    this.arena.getRegion().addSpawn(point, l);
                    this.next = this.formatYellow("Spawnpoint %s added.", point);
                    this.missing.remove("spawnpoints");
                }
            } else if (this.arena.getRegion().removeSpawn(point)) {
                this.next = this.formatYellow("Spawnpoint %s removed.", point);
                if (this.arena.getRegion().getSpawnpoints().size() == 0) {
                    this.missing.add("spawnpoints");
                }
            } else {
                this.next = this.formatYellow("No spawnpoint named %s.", point);
            }
            return this;
        }

        private Prompt chests(Block b, boolean add) {
            if (b != null) {
                if (!(b.getState() instanceof InventoryHolder)) {
                    this.next = "You must be looking at a container.";
                } else if (!this.arena.getRegion().contains(b.getLocation())) {
                    this.next = "You must be inside the arena region.";
                } else {
                    String point = this.getName(b.getLocation());
                    if (add) {
                        this.arena.getRegion().addChest(point, b.getLocation());
                        this.next = this.formatYellow("Container %s added.", point);
                    } else {
                        this.next = this.arena.getRegion().removeChest(point) ? this.formatYellow("Container %s removed.", point) : this.formatYellow("No container named %s.", point);
                    }
                }
            }
            return this;
        }

        private Prompt show(ConversationContext context, String s) {
            ArenaRegion region = this.arena.getRegion();
            String toShow = s.split(" ")[1].trim();
            if (toShow.equalsIgnoreCase("r") || toShow.equalsIgnoreCase("regions")) {
                if (region.isDefined()) {
                    region.showRegion(this.player);
                    if (region.isLobbyDefined()) {
                        region.showLobbyRegion(this.player);
                        this.next = this.formatYellow("Showing both %s.", "regions");
                    } else {
                        this.next = this.formatYellow("Showing %s (lobby region not defined).", "arena region");
                    }
                } else if (region.isLobbyDefined()) {
                    region.showLobbyRegion(this.player);
                    this.next = this.formatYellow("Showing %s (arena region not defined).", "lobby region");
                } else {
                    this.next = "No regions have been defined yet.";
                }
                return this;
            }
            if (toShow.equalsIgnoreCase("ar")) {
                if (region.isDefined()) {
                    this.next = this.formatYellow("Showing %s.", "arena region");
                    region.showRegion(this.player);
                } else {
                    this.next = "The region has not been defined yet.";
                }
                return this;
            }
            if (toShow.equalsIgnoreCase("lr")) {
                if (region.isLobbyDefined()) {
                    this.next = this.formatYellow("Showing %s.", "lobby region");
                    region.showLobbyRegion(this.player);
                } else {
                    this.next = "The lobby region has not been defined yet.";
                }
                return this;
            }
            if (toShow.matches("arena|lobby|spec(tator)?|exit")) {
                this.next = this.formatYellow("Showing %s warp.", toShow);
                Location loc = toShow.equals("arena") ? region.getArenaWarp() : (toShow.equals("lobby") ? region.getLobbyWarp() : (toShow.equals("spec") ? region.getSpecWarp() : (toShow.equals("spectator") ? region.getSpecWarp() : (toShow.equals("exit") ? region.getExitWarp() : null))));
                region.showBlock(this.player, loc);
                return this;
            }
            if (toShow.matches("sp(awn(point)?s?)?")) {
                this.next = this.formatYellow("Showing %s.", "spawnpoints");
                region.showSpawns(this.player);
                return this;
            }
            if (toShow.matches("c((hest(s)?)?|on(tainer(s)?)?)")) {
                this.next = this.formatYellow("Showing %s.", "containers");
                region.showChests(this.player);
                return this;
            }
            return this.acceptInput(context, "show ?");
        }

        private Prompt missing() {
            this.next = this.missing.isEmpty() ? "All required points and warps have been set!" : "Missing points and warps: " + this.getMissing();
            return this;
        }

        private Prompt expandOptions() {
            StringBuilder buffy = new StringBuilder();
            buffy.append("\nUsage: &eexp <region> <amount> <direction>");
            buffy.append("\n\n&r&7Variable details:");
            buffy.append("\n&r&7 region: &rar&7 (arena region) or &rlr&7 (lobby region)");
            buffy.append("\n&r&7 amount: number of blocks to expand by");
            buffy.append("\n&r&7 direction: &rup&7, &rdown&7, or &routs&7");
            buffy.append("\n\n&r&7Examples:");
            buffy.append("\n&r exp ar 5 up   &7expand arena region up by 5");
            buffy.append("\n&r exp lr 10 out   &7expand lobby region out by 10");
            this.next = this.color(buffy.toString());
            return this;
        }

        private Prompt showOptions() {
            StringBuilder buffy = new StringBuilder();
            buffy.append("\nUsage: &eshow <thing>");
            buffy.append("\n\n&r&7Possible things to show:");
            buffy.append("\n&r&7 regions: &rar&7 (arena region) or &rlr&7 (lobby region) or &rr&7 (both)");
            buffy.append("\n&r&7 warps: &rarena&7, &rlobby&7, &rspec&7, or &rexit");
            buffy.append("\n&r&7 points: &rspawns&7 or &rchests&7");
            buffy.append("\n\n&r&7Examples:");
            buffy.append("\n&r show spawns   &7show spawnpoints");
            buffy.append("\n&r show ar   &7show arena region");
            this.next = this.color(buffy.toString());
            return this;
        }

        private Prompt done() {
            if (this.missing.isEmpty()) {
                this.tell((Conversable)this.player, "Setup complete! Arena is ready to be used!");
            } else {
                this.tell((Conversable)this.player, "Setup incomplete. Missing points and warps: " + this.getMissing());
            }
            return Prompt.END_OF_CONVERSATION;
        }

        private Prompt invalidInput() {
            this.next = this.formatYellow("Invalid input. Type %s for help", "?");
            return this;
        }

        private String getMissing() {
            StringBuilder buffy = new StringBuilder();
            for (String m : this.missing) {
                buffy.append("\n").append(m);
            }
            return buffy.toString();
        }

        private String color(String s) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        }

        private boolean inArenaWorld() {
            return this.player.getWorld().getName().equals(this.arena.getWorld().getName());
        }

        private void tell(Conversable whom, String msg) {
            whom.sendRawMessage(ChatColor.GREEN + "[MobArena] " + ChatColor.RESET + msg);
        }

        private String formatYellow(String msg, String arg) {
            return String.format(msg, ChatColor.YELLOW + arg + ChatColor.RESET);
        }

        private String getName(Location l) {
            return l.getBlockX() + "," + l.getBlockY() + "," + l.getBlockZ();
        }
    }
}

