/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import java.util.StringJoiner;
import org.bukkit.Server;

class ServerVersionCheck {
    private static final String[] EXACTS = new String[]{"1.8", "1.9", "1.10", "1.11", "1.12"};
    private static final String[] PREFIXES = new String[]{"1.8.", "1.9.", "1.10.", "1.11.", "1.12."};

    ServerVersionCheck() {
    }

    static void check(Server server) {
        String version = ServerVersionCheck.getMinecraftVersion(server);
        for (String exact : EXACTS) {
            if (!version.equals(exact)) continue;
            ServerVersionCheck.fail(version);
        }
        for (String prefix : PREFIXES) {
            if (!version.startsWith(prefix)) continue;
            ServerVersionCheck.fail(version);
        }
    }

    private static String getMinecraftVersion(Server server) {
        String version = server.getVersion();
        int start = version.indexOf("MC: ") + 4;
        int end = version.length() - 1;
        return version.substring(start, end);
    }

    private static void fail(String version) {
        throw new IllegalStateException(new StringJoiner(" ").add("Incompatible server version!").add("This build does not work on " + version + ".").add("Perhaps you downloaded the wrong build?").toString());
    }
}

