/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;

public class PluginVersionCheck {
    private static final String RESOURCE_ID = "34110";
    private static final String ENDPOINT = "https://api.spigotmc.org/legacy/update.php?resource=34110";
    private static final int TIMEOUT = 5000;
    private static final long CACHE_TTL = 3600000L;
    private static long timeOfLastCheck = 0L;
    private static String messageOfLastCheck = null;

    public static void check(Plugin plugin, Consumer<String> block) {
        if (PluginVersionCheck.cacheIsFresh()) {
            PluginVersionCheck.checkFromCache(plugin, block);
        } else {
            PluginVersionCheck.checkFromRemote(plugin, block);
        }
    }

    private static boolean cacheIsFresh() {
        return System.currentTimeMillis() < timeOfLastCheck + 3600000L;
    }

    private static void checkFromCache(Plugin plugin, Consumer<String> block) {
        plugin.getServer().getScheduler().runTask(plugin, () -> {
            if (messageOfLastCheck != null) {
                block.accept(messageOfLastCheck);
            }
        });
    }

    private static void checkFromRemote(Plugin plugin, Consumer<String> block) {
        PluginVersionCheck.resetCache();
        plugin.getServer().getScheduler().runTaskAsynchronously(plugin, () -> {
            String local = plugin.getDescription().getVersion();
            String remote = PluginVersionCheck.getRemoteVersion();
            plugin.getServer().getScheduler().runTask(plugin, () -> {
                if (remote != null && PluginVersionCheck.lessThan(local, remote)) {
                    String message = String.format("v%s is now available! You are running v%s.", remote, local);
                    PluginVersionCheck.hydrateCache(message);
                    block.accept(message);
                }
            });
        });
    }

    private static void resetCache() {
        timeOfLastCheck = System.currentTimeMillis();
        messageOfLastCheck = null;
    }

    private static void hydrateCache(String message) {
        timeOfLastCheck = System.currentTimeMillis();
        messageOfLastCheck = message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getRemoteVersion() {
        try (InputStream is = PluginVersionCheck.getEndpointStream();
             Scanner scanner = new Scanner(is);){
            if (!scanner.hasNext()) return null;
            String string = scanner.next();
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static InputStream getEndpointStream() throws IOException {
        URL url = new URL(ENDPOINT);
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        return connection.getInputStream();
    }

    static boolean lessThan(String local, String remote) {
        if (local == null || remote == null) {
            return false;
        }
        String localVersion = local.split("-")[0];
        String remoteVersion = remote.split("-")[0];
        String[] localParts = localVersion.split("\\.");
        String[] remoteParts = remoteVersion.split("\\.");
        int length = Math.max(localParts.length, remoteParts.length);
        for (int i = 0; i < length; ++i) {
            int remotePart;
            int localPart = Integer.parseInt(localParts.length > i ? localParts[i] : "0");
            if (localPart == (remotePart = Integer.parseInt(remoteParts.length > i ? remoteParts[i] : "0"))) continue;
            return localPart < remotePart;
        }
        return local.endsWith("-SNAPSHOT");
    }
}

