/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.healthbar.HealthBar;
import com.garbagemule.MobArena.waves.MABoss;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MonsterManager {
    private Set<LivingEntity> monsters = new HashSet<LivingEntity>();
    private Set<LivingEntity> sheep = new HashSet<LivingEntity>();
    private Set<LivingEntity> golems = new HashSet<LivingEntity>();
    private Map<LivingEntity, MABoss> bosses = new HashMap<LivingEntity, MABoss>();
    private Map<LivingEntity, List<ItemStack>> suppliers = new HashMap<LivingEntity, List<ItemStack>>();
    private Set<LivingEntity> mounts = new HashSet<LivingEntity>();
    private Map<Entity, Player> petToPlayer = new HashMap<Entity, Player>();
    private Map<Player, Set<Entity>> playerToPets = new HashMap<Player, Set<Entity>>();

    public void reset() {
        this.monsters.clear();
        this.sheep.clear();
        this.golems.clear();
        this.bosses.clear();
        this.suppliers.clear();
        this.mounts.clear();
        this.petToPlayer.clear();
        this.playerToPets.clear();
    }

    public void clear() {
        this.bosses.values().stream().map(MABoss::getHealthBar).filter(Objects::nonNull).forEach(HealthBar::removeAll);
        this.removeAll(this.monsters);
        this.removeAll(this.sheep);
        this.removeAll(this.golems);
        this.removeAll(this.bosses.keySet());
        this.removeAll(this.suppliers.keySet());
        this.removeAll(this.mounts);
        this.removeAll(this.petToPlayer.keySet());
        this.reset();
    }

    private void removeAll(Collection<? extends Entity> collection) {
        for (Entity entity : collection) {
            if (entity == null) continue;
            entity.remove();
        }
    }

    public void remove(Entity e) {
        if (this.monsters.remove(e)) {
            this.sheep.remove(e);
            this.golems.remove(e);
            this.suppliers.remove(e);
            MABoss boss = this.bosses.remove(e);
            if (boss != null) {
                boss.setDead(true);
            }
        }
    }

    public Set<LivingEntity> getMonsters() {
        return this.monsters;
    }

    public void addMonster(LivingEntity e) {
        this.monsters.add(e);
    }

    public boolean removeMonster(Entity e) {
        return this.monsters.remove(e);
    }

    public Set<LivingEntity> getExplodingSheep() {
        return this.sheep;
    }

    public void addExplodingSheep(LivingEntity e) {
        this.sheep.add(e);
    }

    public boolean removeExplodingSheep(LivingEntity e) {
        return this.sheep.remove(e);
    }

    public Set<LivingEntity> getGolems() {
        return this.golems;
    }

    public void addGolem(LivingEntity e) {
        this.golems.add(e);
    }

    public boolean removeGolem(LivingEntity e) {
        return this.golems.remove(e);
    }

    public void addPet(Player player, Entity pet) {
        this.petToPlayer.put(pet, player);
        this.playerToPets.computeIfAbsent(player, key -> new HashSet()).add(pet);
    }

    public boolean hasPet(Entity e) {
        return this.petToPlayer.containsKey(e);
    }

    public void removePet(Entity pet) {
        Set<Entity> pets;
        pet.remove();
        Player owner = this.petToPlayer.remove(pet);
        if (owner != null && (pets = this.playerToPets.get(owner)) != null) {
            pets.remove(pet);
        }
    }

    public Player getOwner(Entity pet) {
        return this.petToPlayer.get(pet);
    }

    public Collection<Entity> getPets(Player owner) {
        Set<Entity> pets = this.playerToPets.get(owner);
        if (pets != null) {
            return pets;
        }
        return Collections.emptySet();
    }

    public void removePets(Player p) {
        Set<Entity> pets = this.playerToPets.remove(p);
        if (pets != null) {
            pets.forEach(Entity::remove);
            pets.clear();
        }
    }

    public void addMount(LivingEntity e) {
        this.mounts.add(e);
    }

    public boolean hasMount(Entity e) {
        return this.mounts.contains(e);
    }

    public boolean removeMount(Entity e) {
        return this.mounts.remove(e);
    }

    public void removeMounts() {
        for (LivingEntity e : this.mounts) {
            e.remove();
        }
    }

    public void addSupplier(LivingEntity e, List<ItemStack> drops) {
        this.suppliers.put(e, drops);
    }

    public List<ItemStack> getLoot(Entity e) {
        return this.suppliers.get(e);
    }

    public MABoss addBoss(LivingEntity e, double maxHealth) {
        MABoss b = new MABoss(e, maxHealth);
        this.bosses.put(e, b);
        return b;
    }

    public MABoss removeBoss(LivingEntity e) {
        return this.bosses.remove(e);
    }

    public MABoss getBoss(LivingEntity e) {
        return this.bosses.get(e);
    }

    public Set<LivingEntity> getBossMonsters() {
        return this.bosses.keySet();
    }
}

