/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MobArenaHandler {
    private MobArena plugin = (MobArena)Bukkit.getServer().getPluginManager().getPlugin("MobArena");

    public boolean inRegion(Location loc) {
        for (Arena arena : this.plugin.getArenaMaster().getArenas()) {
            if (!arena.getRegion().contains(loc)) continue;
            return true;
        }
        return false;
    }

    public boolean inRegion(Arena arena, Location loc) {
        return arena != null && arena.getRegion().contains(loc);
    }

    public boolean inRegion(String arenaName, Location loc) {
        Arena arena = this.plugin.getArenaMaster().getArenaWithName(arenaName);
        if (arena == null) {
            throw new NullPointerException("There is no arena with that name");
        }
        return arena.getRegion().contains(loc);
    }

    public boolean inRunningRegion(Location loc) {
        return this.inRegion(loc, false, true);
    }

    public boolean inEnabledRegion(Location loc) {
        return this.inRegion(loc, true, false);
    }

    private boolean inRegion(Location loc, boolean enabled, boolean running) {
        if (this.plugin.getArenaMaster() == null) {
            return false;
        }
        for (Arena arena : this.plugin.getArenaMaster().getArenas()) {
            if (!arena.getRegion().contains(loc) || (!running || !arena.isRunning()) && (!enabled || !arena.isEnabled())) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerInArena(Player player) {
        return this.plugin.getArenaMaster().getArenaWithPlayer(player) != null;
    }

    public boolean isPlayerInArena(String playerName) {
        return this.plugin.getArenaMaster().getArenaWithPlayer(playerName) != null;
    }

    public String getPlayerClass(Player player) {
        Arena arena = this.plugin.getArenaMaster().getArenaWithPlayer(player);
        if (arena == null) {
            return null;
        }
        return this.getPlayerClass(arena, player);
    }

    public String getPlayerClass(Arena arena, Player player) {
        ArenaPlayer ap = arena.getArenaPlayer(player);
        if (ap == null) {
            return null;
        }
        ArenaClass ac = ap.getArenaClass();
        if (ac == null) {
            return null;
        }
        return ac.getLowercaseName();
    }

    public boolean isMonsterInArena(LivingEntity entity) {
        return this.plugin.getArenaMaster().getArenaWithMonster((Entity)entity) != null;
    }

    public boolean isPetInArena(LivingEntity wolf) {
        return this.plugin.getArenaMaster().getArenaWithPet((Entity)wolf) != null;
    }

    public Arena getArenaAtLocation(Location loc) {
        return this.plugin.getArenaMaster().getArenaAtLocation(loc);
    }

    public Arena getArenaWithPlayer(Player p) {
        return this.plugin.getArenaMaster().getArenaWithPlayer(p);
    }

    public Arena getArenaWithPet(Entity wolf) {
        return this.plugin.getArenaMaster().getArenaWithPet(wolf);
    }

    public Arena getArenaWithMonster(Entity monster) {
        return this.plugin.getArenaMaster().getArenaWithMonster(monster);
    }
}

