/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaMasterImpl;
import com.garbagemule.MobArena.ConfigError;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.PluginVersionCheck;
import com.garbagemule.MobArena.ServerVersionCheck;
import com.garbagemule.MobArena.commands.CommandHandler;
import com.garbagemule.MobArena.config.LoadsConfigFile;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.listeners.MAGlobalListener;
import com.garbagemule.MobArena.listeners.MagicSpellsListener;
import com.garbagemule.MobArena.metrics.ArenaCountChart;
import com.garbagemule.MobArena.metrics.ClassChestsChart;
import com.garbagemule.MobArena.metrics.ClassCountChart;
import com.garbagemule.MobArena.metrics.FoodRegenChart;
import com.garbagemule.MobArena.metrics.IsolatedChatChart;
import com.garbagemule.MobArena.metrics.MonsterInfightChart;
import com.garbagemule.MobArena.metrics.PvpEnabledChart;
import com.garbagemule.MobArena.metrics.VaultChart;
import com.garbagemule.MobArena.metrics.bukkit.Metrics;
import com.garbagemule.MobArena.signs.ArenaSign;
import com.garbagemule.MobArena.signs.SignBootstrap;
import com.garbagemule.MobArena.signs.SignListeners;
import com.garbagemule.MobArena.things.ThingManager;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import com.garbagemule.MobArena.waves.ability.AbilityManager;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MobArena
extends JavaPlugin {
    private ArenaMaster arenaMaster;
    private Economy economy;
    private FileConfiguration config;
    private LoadsConfigFile loadsConfigFile;
    private Throwable lastFailureCause;
    public static final double MIN_PLAYER_DISTANCE_SQUARED = 225.0;
    public static Random random = new Random();
    private Messenger messenger;
    private ThingManager thingman;
    private SignListeners signListeners;

    public void onLoad() {
        this.thingman = new ThingManager(this);
    }

    public void onEnable() {
        ServerVersionCheck.check(this.getServer());
        try {
            this.setup();
            this.reload();
            this.checkForUpdates();
        }
        catch (ConfigError e) {
            this.getLogger().log(Level.SEVERE, "You have an error in your config-file!\n\n  " + e.getMessage() + "\n");
            this.getLogger().log(Level.SEVERE, "Fix it, then run /ma reload");
        }
    }

    public void onDisable() {
        if (this.arenaMaster != null) {
            this.arenaMaster.getArenas().forEach(Arena::forceEnd);
            this.arenaMaster.resetArenaMap();
            this.arenaMaster = null;
        }
        this.loadsConfigFile = null;
        ConfigurationSerialization.unregisterClass(ArenaSign.class);
    }

    private void setup() {
        try {
            this.createDataFolder();
            this.setupArenaMaster();
            this.setupCommandHandler();
            this.registerConfigurationSerializers();
            this.setupVault();
            this.setupMagicSpells();
            this.setupBossAbilities();
            this.setupListeners();
            this.setupMetrics();
        }
        catch (RuntimeException e) {
            this.setLastFailureCauseAndRethrow(e);
        }
        this.lastFailureCause = null;
    }

    private void createDataFolder() {
        File dir = this.getDataFolder();
        if (!dir.exists()) {
            if (dir.mkdir()) {
                this.getLogger().info("Data folder plugins/MobArena created.");
            } else {
                this.getLogger().warning("Failed to create data folder plugins/MobArena!");
            }
        }
    }

    private void setupArenaMaster() {
        this.arenaMaster = new ArenaMasterImpl(this);
    }

    private void setupCommandHandler() {
        this.getCommand("ma").setExecutor((CommandExecutor)new CommandHandler(this));
    }

    private void registerConfigurationSerializers() {
        ConfigurationSerialization.registerClass(ArenaSign.class);
    }

    private void setupVault() {
        Plugin vaultPlugin = this.getServer().getPluginManager().getPlugin("Vault");
        if (vaultPlugin == null) {
            this.getLogger().info("Vault was not found. Economy rewards will not work.");
            return;
        }
        ServicesManager manager = this.getServer().getServicesManager();
        RegisteredServiceProvider e = manager.getRegistration(Economy.class);
        if (e != null) {
            this.economy = (Economy)e.getProvider();
            this.getLogger().info("Vault found; economy rewards enabled.");
        } else {
            this.getLogger().warning("Vault found, but no economy plugin detected. Economy rewards will not work!");
        }
    }

    private void setupMagicSpells() {
        Plugin spells = this.getServer().getPluginManager().getPlugin("MagicSpells");
        if (spells == null) {
            return;
        }
        this.getLogger().info("MagicSpells found, loading config-file.");
        this.getServer().getPluginManager().registerEvents((Listener)new MagicSpellsListener(this), (Plugin)this);
    }

    private void setupBossAbilities() {
        AbilityManager.loadCoreAbilities();
        AbilityManager.loadCustomAbilities(this.getDataFolder());
    }

    private void setupListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new MAGlobalListener(this, this.arenaMaster), (Plugin)this);
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics((Plugin)this);
        metrics.addCustomChart(new VaultChart(this));
        metrics.addCustomChart(new ArenaCountChart(this));
        metrics.addCustomChart(new ClassCountChart(this));
        metrics.addCustomChart(new ClassChestsChart(this));
        metrics.addCustomChart(new FoodRegenChart(this));
        metrics.addCustomChart(new IsolatedChatChart(this));
        metrics.addCustomChart(new MonsterInfightChart(this));
        metrics.addCustomChart(new PvpEnabledChart(this));
    }

    public void reload() {
        try {
            this.reloadConfig();
            this.reloadGlobalMessenger();
            this.reloadArenaMaster();
            this.reloadAnnouncementsFile();
            this.reloadSigns();
        }
        catch (RuntimeException e) {
            this.setLastFailureCauseAndRethrow(e);
        }
        this.lastFailureCause = null;
    }

    public void reloadConfig() {
        if (this.loadsConfigFile == null) {
            this.loadsConfigFile = new LoadsConfigFile(this);
        }
        this.config = this.loadsConfigFile.load();
    }

    private void reloadGlobalMessenger() {
        String prefix = this.config.getString("global-settings.prefix", "");
        if (prefix.isEmpty()) {
            prefix = ChatColor.GREEN + "[MobArena] ";
        }
        this.messenger = new Messenger(prefix);
    }

    private void reloadArenaMaster() {
        this.arenaMaster.getArenas().forEach(Arena::forceEnd);
        this.arenaMaster.initialize();
    }

    private void reloadAnnouncementsFile() {
        File file = new File(this.getDataFolder(), "announcements.yml");
        try {
            if (file.createNewFile()) {
                this.getLogger().info("announcements.yml created.");
                YamlConfiguration yaml = Msg.toYaml();
                yaml.save(file);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            YamlConfiguration yaml = new YamlConfiguration();
            yaml.load(file);
            ConfigUtils.addMissingRemoveObsolete(file, Msg.toYaml(), (FileConfiguration)yaml);
            Msg.load((ConfigurationSection)yaml);
        }
        catch (IOException e) {
            throw new RuntimeException("There was an error reading the announcements-file:\n" + e.getMessage());
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException("\n\n>>>\n>>> There is an error in your announements-file! Handle it!\n>>> Here's what snakeyaml says:\n>>>\n\n" + e.getMessage());
        }
    }

    private void reloadSigns() {
        if (this.signListeners != null) {
            this.signListeners.unregister();
        }
        SignBootstrap bootstrap = SignBootstrap.create(this);
        this.signListeners = new SignListeners();
        this.signListeners.register(bootstrap);
    }

    private void checkForUpdates() {
        if (this.getConfig().getBoolean("global-settings.update-notification", false)) {
            PluginVersionCheck.check((Plugin)this, this.getLogger()::info);
        }
    }

    private void setLastFailureCauseAndRethrow(RuntimeException up) {
        this.lastFailureCause = up;
        throw up;
    }

    public Throwable getLastFailureCause() {
        return this.lastFailureCause;
    }

    public File getPluginFile() {
        return this.getFile();
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public ArenaMaster getArenaMaster() {
        return this.arenaMaster;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Messenger getGlobalMessenger() {
        return this.messenger;
    }

    public ThingManager getThingManager() {
        return this.thingman;
    }
}

