/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.MonsterManager;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.RewardManager;
import com.garbagemule.MobArena.events.ArenaCompleteEvent;
import com.garbagemule.MobArena.events.NewWaveEvent;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.healthbar.CreatesHealthBar;
import com.garbagemule.MobArena.healthbar.HealthBar;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.things.ExperienceThing;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.waves.MABoss;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.WaveManager;
import com.garbagemule.MobArena.waves.enums.WaveType;
import com.garbagemule.MobArena.waves.types.BossWave;
import com.garbagemule.MobArena.waves.types.SupplyWave;
import com.garbagemule.MobArena.waves.types.UpgradeWave;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MASpawnThread
implements Runnable {
    private MobArena plugin;
    private Arena arena;
    private ArenaRegion region;
    private RewardManager rewardManager;
    private WaveManager waveManager;
    private MonsterManager monsterManager;
    private CreatesHealthBar createsHealthBar;
    private int playerCount;
    private int monsterLimit;
    private boolean waveClear;
    private boolean bossClear;
    private boolean preBossClear;
    private boolean wavesAsLevel;
    private int waveInterval;
    private int nextWaveDelay;
    private BukkitTask task;

    public MASpawnThread(MobArena plugin, Arena arena) {
        this.plugin = plugin;
        this.arena = arena;
        this.region = arena.getRegion();
        this.rewardManager = arena.getRewardManager();
        this.waveManager = arena.getWaveManager();
        this.monsterManager = arena.getMonsterManager();
        this.createsHealthBar = new CreatesHealthBar(arena.getSettings().getString("boss-health-bar", "none"));
        this.reset();
    }

    public void reset() {
        this.waveManager.reset();
        this.playerCount = this.arena.getPlayersInArena().size();
        this.monsterLimit = this.arena.getSettings().getInt("monster-limit", 100);
        this.waveClear = this.arena.getSettings().getBoolean("clear-wave-before-next", false);
        this.bossClear = this.arena.getSettings().getBoolean("clear-boss-before-next", false);
        this.preBossClear = this.arena.getSettings().getBoolean("clear-wave-before-boss", false);
        this.wavesAsLevel = this.arena.getSettings().getBoolean("display-waves-as-level", false);
        this.waveInterval = this.arena.getSettings().getInt("wave-interval", 3);
        this.nextWaveDelay = this.arena.getSettings().getInt("next-wave-delay", 0);
    }

    public void start() {
        if (this.task != null) {
            this.plugin.getLogger().warning("Starting spawner in arena " + this.arena.configName() + " with existing spawner still running. This should never happen.");
            this.task.cancel();
            this.task = null;
        }
        int delay = this.arena.getSettings().getInt("first-wave-delay", 5) * 20;
        this.task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.arena.getEventListener().pvpActivate();
            this.run();
        }, (long)delay);
    }

    public void stop() {
        if (this.task == null) {
            this.plugin.getLogger().warning("Can't stop non-existent spawner in arena " + this.arena.configName() + ". This should never happen.");
            return;
        }
        this.arena.getEventListener().pvpDeactivate();
        this.task.cancel();
        this.task = null;
    }

    @Override
    public void run() {
        if (!this.arena.isRunning() || this.arena.getPlayersInArena().isEmpty()) {
            return;
        }
        this.removeDeadMonsters();
        this.removeCheatingPlayers();
        if (!this.arena.isRunning()) {
            return;
        }
        int nextWave = this.waveManager.getWaveNumber() + 1;
        if (!this.isWaveClear()) {
            this.arena.scheduleTask(this, 60);
            return;
        }
        NewWaveEvent event = new NewWaveEvent(this.arena, this.waveManager.getNext(), nextWave);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.arena.scheduleTask(this, 60);
            return;
        }
        if (this.nextWaveDelay > 0) {
            this.task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::spawnNextWave, (long)(this.nextWaveDelay * 20));
        } else {
            this.spawnNextWave();
        }
    }

    private void spawnNextWave() {
        int nextWave = this.waveManager.getWaveNumber() + 1;
        this.grantRewards(nextWave - 1);
        if (nextWave > 1 && nextWave - 1 == this.waveManager.getFinalWave()) {
            ArenaCompleteEvent complete = new ArenaCompleteEvent(this.arena);
            this.plugin.getServer().getPluginManager().callEvent((Event)complete);
            ArrayList<Player> players = new ArrayList<Player>(this.arena.getPlayersInArena());
            for (Player p : players) {
                if (this.arena.getSettings().getBoolean("keep-exp", false)) {
                    this.arena.getRewardManager().addReward(p, new ExperienceThing(p.getTotalExperience()));
                }
                this.arena.playerLeave(p);
            }
            return;
        }
        this.spawnWave(nextWave);
        this.updateStats(nextWave);
        this.task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)this, (long)(this.waveInterval * 20));
    }

    private void spawnWave(int wave) {
        Wave w = this.waveManager.next();
        w.announce(this.arena, wave);
        this.arena.getScoreboard().updateWave(wave);
        if (this.wavesAsLevel) {
            for (Player p : this.arena.getPlayersInArena()) {
                p.setLevel(wave);
                p.setExp(0.0f);
            }
        }
        if (w.getType() == WaveType.UPGRADE) {
            this.handleUpgradeWave(w);
            return;
        }
        Map<MACreature, Integer> monsters = w.getMonstersToSpawn(wave, this.playerCount, this.arena);
        List<Location> spawnpoints = w.getSpawnpoints(this.arena);
        World world = this.arena.getWorld();
        int totalSpawnpoints = spawnpoints.size();
        int index = 0;
        double mul = w.getHealthMultiplier();
        for (Map.Entry<MACreature, Integer> entry : monsters.entrySet()) {
            int i = 0;
            while (i < entry.getValue()) {
                if (this.monsterManager.getMonsters().size() >= this.monsterLimit) {
                    return;
                }
                Location spawnpoint = spawnpoints.get(index % totalSpawnpoints);
                LivingEntity e = entry.getKey().spawn(this.arena, world, spawnpoint);
                e.addPotionEffects(w.getEffects());
                this.monsterManager.addMonster(e);
                int health = (int)Math.max(1.0, e.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * mul);
                try {
                    e.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue((double)health);
                    e.setHealth((double)health);
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.getLogger().severe("Can't set health to " + health + ", using default health. If you are running Spigot, set 'maxHealth' higher in your Spigot settings.");
                    this.plugin.getLogger().severe(ex.getLocalizedMessage());
                    if (w.getType() == WaveType.BOSS) {
                        ((BossWave)w).setBossName("SPIGOT ERROR");
                    }
                    e.setCustomName("SPIGOT ERROR");
                }
                switch (w.getType()) {
                    case BOSS: {
                        BossWave bw = (BossWave)w;
                        double maxHealth = bw.getMaxHealth(this.playerCount);
                        MABoss boss = this.monsterManager.addBoss(e, maxHealth);
                        HealthBar healthbar = this.createsHealthBar.create((Entity)e, bw.getBossName());
                        this.arena.getPlayersInArena().forEach(healthbar::addPlayer);
                        healthbar.setProgress(1.0);
                        boss.setHealthBar(healthbar);
                        boss.setReward(bw.getReward());
                        boss.setDrops(bw.getDrops());
                        bw.addMABoss(boss);
                        bw.activateAbilities(this.arena);
                        if (bw.getBossName() == null) break;
                        e.setCustomName(bw.getBossName());
                        e.setCustomNameVisible(true);
                        break;
                    }
                    case SWARM: {
                        health = (int)(mul < 1.0 ? e.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * mul : 1.0);
                        health = Math.max(1, health);
                        e.setHealth(Math.min((double)health, e.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
                        break;
                    }
                    case SUPPLY: {
                        SupplyWave sw = (SupplyWave)w;
                        this.monsterManager.addSupplier(e, sw.getDropList());
                        break;
                    }
                }
                ++i;
                ++index;
            }
        }
    }

    private void handleUpgradeWave(Wave w) {
        UpgradeWave uw = (UpgradeWave)w;
        for (Player p : this.arena.getPlayersInArena()) {
            String className = this.arena.getArenaPlayer(p).getArenaClass().getLowercaseName();
            uw.grantItems(p, className);
            uw.grantItems(p, "all");
        }
        this.plugin.getArenaMaster().getSpawnsPets().spawn(this.arena);
    }

    private boolean isWaveClear() {
        if (this.monsterManager.getMonsters().size() >= this.monsterLimit) {
            return false;
        }
        if (this.bossClear && !this.monsterManager.getBossMonsters().isEmpty()) {
            return false;
        }
        if (this.waveClear && !this.monsterManager.getMonsters().isEmpty()) {
            return false;
        }
        if (this.preBossClear && this.waveManager.getNext().getType() == WaveType.BOSS && !this.monsterManager.getMonsters().isEmpty()) {
            return false;
        }
        return this.monsterManager.getMonsters().isEmpty() || this.waveManager.getWaveNumber() != this.waveManager.getFinalWave();
    }

    private void removeDeadMonsters() {
        ArrayList<LivingEntity> tmp = new ArrayList<LivingEntity>(this.monsterManager.getMonsters());
        for (Entity entity : tmp) {
            if (entity == null || !entity.isDead() && this.region.contains(entity.getLocation())) continue;
            this.monsterManager.remove(entity);
            entity.remove();
        }
    }

    private void removeCheatingPlayers() {
        ArrayList<Player> players = new ArrayList<Player>(this.arena.getPlayersInArena());
        for (Player p : players) {
            if (this.region.contains(p.getLocation())) continue;
            this.arena.getMessenger().tell((CommandSender)p, "Leaving so soon?");
            p.getInventory().clear();
            this.arena.playerLeave(p);
        }
    }

    private void grantRewards(int wave) {
        for (Map.Entry<Integer, List<Thing>> entry : this.arena.getEveryWaveEntrySet()) {
            if (wave <= 0 || wave % entry.getKey() != 0) continue;
            this.addReward(entry.getValue());
        }
        List<Thing> after = this.arena.getAfterWaveReward(wave);
        if (after != null) {
            this.addReward(after);
        }
    }

    private void updateStats(int wave) {
        for (ArenaPlayer ap : this.arena.getArenaPlayerSet()) {
            if (!this.arena.getPlayersInArena().contains(ap.getPlayer())) continue;
            ap.getStats().inc("lastWave");
        }
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    private void addReward(List<Thing> rewards) {
        for (Player p : this.arena.getPlayersInArena()) {
            Thing reward = rewards.get(MobArena.random.nextInt(rewards.size()));
            this.rewardManager.addReward(p, reward);
            if (reward == null) {
                this.arena.getMessenger().tell((CommandSender)p, "ERROR! Problem with rewards. Notify server host!");
                this.plugin.getLogger().warning("Could not add null reward. Please check the config-file!");
                continue;
            }
            this.arena.getMessenger().tell((CommandSender)p, Msg.WAVE_REWARD, reward.toString());
        }
    }
}

