/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.ArenaImpl;
import com.garbagemule.MobArena.ConfigError;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.SpawnsPets;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.things.InvalidThingInputString;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.util.JoinInterruptTimer;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ArenaMasterImpl
implements ArenaMaster {
    private MobArena plugin;
    private List<Arena> arenas;
    private Map<Player, Arena> arenaMap;
    private Map<String, ArenaClass> classes;
    private Set<String> allowedCommands;
    private SpawnsPets spawnsPets;
    private boolean enabled;
    private JoinInterruptTimer joinInterruptTimer;

    public ArenaMasterImpl(MobArena plugin) {
        this.plugin = plugin;
        this.arenas = new ArrayList<Arena>();
        this.arenaMap = new HashMap<Player, Arena>();
        this.classes = new HashMap<String, ArenaClass>();
        this.allowedCommands = new HashSet<String>();
        this.spawnsPets = new SpawnsPets();
        this.joinInterruptTimer = new JoinInterruptTimer();
    }

    @Override
    public MobArena getPlugin() {
        return this.plugin;
    }

    @Override
    public Messenger getGlobalMessenger() {
        return this.plugin.getGlobalMessenger();
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getLastFailureCause() == null && this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
        FileConfiguration config = this.plugin.getConfig();
        if (config != null) {
            config.set("global-settings.enabled", (Object)this.enabled);
            this.plugin.saveConfig();
        }
    }

    @Override
    public boolean notifyOnUpdates() {
        FileConfiguration config = this.plugin.getConfig();
        return config != null && config.getBoolean("global-settings.update-notification", false);
    }

    @Override
    public List<Arena> getArenas() {
        return this.arenas;
    }

    @Override
    public Map<String, ArenaClass> getClasses() {
        return this.classes;
    }

    @Override
    public void addPlayer(Player p, Arena arena) {
        this.arenaMap.put(p, arena);
    }

    @Override
    public Arena removePlayer(Player p) {
        return this.arenaMap.remove(p);
    }

    @Override
    public void resetArenaMap() {
        this.arenaMap.clear();
    }

    @Override
    public boolean isAllowed(String command) {
        return this.allowedCommands.contains(command);
    }

    @Override
    public JoinInterruptTimer getJoinInterruptTimer() {
        return this.joinInterruptTimer;
    }

    @Override
    public List<Arena> getEnabledArenas() {
        return this.getEnabledArenas(this.arenas);
    }

    @Override
    public List<Arena> getEnabledArenas(List<Arena> arenas) {
        ArrayList<Arena> result = new ArrayList<Arena>(arenas.size());
        for (Arena arena : arenas) {
            if (!arena.isEnabled()) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Arena> getPermittedArenas(Player p) {
        ArrayList<Arena> result = new ArrayList<Arena>(this.arenas.size());
        for (Arena arena : this.arenas) {
            if (!arena.hasPermission(p)) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Arena> getEnabledAndPermittedArenas(Player p) {
        ArrayList<Arena> result = new ArrayList<Arena>(this.arenas.size());
        for (Arena arena : this.arenas) {
            if (!arena.isEnabled() || !arena.hasPermission(p)) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public Arena getArenaAtLocation(Location loc) {
        for (Arena arena : this.arenas) {
            if (!arena.getRegion().contains(loc)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public List<Arena> getArenasInWorld(World world) {
        ArrayList<Arena> result = new ArrayList<Arena>(this.arenas.size());
        for (Arena arena : this.arenas) {
            if (!arena.getWorld().equals(world)) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Player> getAllPlayers() {
        ArrayList<Player> result = new ArrayList<Player>(this.arenas.size());
        for (Arena arena : this.arenas) {
            result.addAll(arena.getAllPlayers());
        }
        return result;
    }

    @Override
    public List<Player> getAllPlayersInArena(String arenaName) {
        Arena arena = this.getArenaWithName(arenaName);
        return arena != null ? new ArrayList<Player>(arena.getPlayersInArena()) : new ArrayList();
    }

    @Override
    public List<Player> getAllLivingPlayers() {
        ArrayList<Player> result = new ArrayList<Player>();
        for (Arena arena : this.arenas) {
            result.addAll(arena.getPlayersInArena());
        }
        return result;
    }

    @Override
    public List<Player> getLivingPlayersInArena(String arenaName) {
        Arena arena = this.getArenaWithName(arenaName);
        return arena != null ? new ArrayList<Player>(arena.getPlayersInArena()) : new ArrayList();
    }

    @Override
    public Arena getArenaWithPlayer(Player p) {
        return this.arenaMap.get(p);
    }

    @Override
    public Arena getArenaWithPlayer(String playerName) {
        return this.arenaMap.get(this.plugin.getServer().getPlayer(playerName));
    }

    @Override
    public Arena getArenaWithSpectator(Player p) {
        for (Arena arena : this.arenas) {
            if (!arena.getSpectators().contains(p)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithMonster(Entity e) {
        for (Arena arena : this.arenas) {
            if (!arena.getMonsterManager().getMonsters().contains(e)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithPet(Entity e) {
        for (Arena arena : this.arenas) {
            if (!arena.hasPet(e)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithName(String configName) {
        return this.getArenaWithName(this.arenas, configName);
    }

    @Override
    public Arena getArenaWithName(Collection<Arena> arenas, String configName) {
        for (Arena arena : arenas) {
            if (!arena.configName().equalsIgnoreCase(configName)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public void initialize() {
        this.loadSettings();
        this.loadClasses();
        this.loadArenas();
    }

    @Override
    public void loadSettings() {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("global-settings");
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "global-settings.yml", section);
        this.enabled = section.getBoolean("enabled", true);
        String cmds = section.getString("allowed-commands", "");
        String[] parts = cmds.split(",");
        this.allowedCommands.add("/ma");
        for (String part : parts) {
            this.allowedCommands.add(part.trim().toLowerCase());
        }
        this.loadPetItems(section);
    }

    private void loadPetItems(ConfigurationSection settings) {
        this.spawnsPets.clear();
        ConfigurationSection items = settings.getConfigurationSection("pet-items");
        for (String key : items.getKeys(false)) {
            Material material;
            EntityType entity;
            try {
                entity = EntityType.valueOf((String)key.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigError("Failed to parse entity type for pet item: " + key);
            }
            if (!entity.isAlive()) {
                throw new ConfigError("Invalid entity type for pet item: " + key);
            }
            try {
                material = Material.getMaterial((String)items.getString(key, "").toUpperCase());
            }
            catch (Exception e) {
                throw new ConfigError("Failed to parse material type for pet item: " + key);
            }
            if (material == null) {
                throw new ConfigError("Failed to parse material type for pet item: " + key);
            }
            this.spawnsPets.register(material, entity);
        }
    }

    @Override
    public void loadClasses() {
        ConfigurationSection section = ConfigUtils.makeSection((ConfigurationSection)this.plugin.getConfig(), "classes");
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "classes.yml", section);
        this.classes = new HashMap<String, ArenaClass>();
        Set classNames = section.getKeys(false);
        for (String className : classNames) {
            this.loadClass(className);
        }
        this.loadClass("My Items");
    }

    private ArenaClass loadClass(String classname) {
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection section = config.getConfigurationSection("classes." + classname);
        String lowercase = classname.toLowerCase().replace(" ", "");
        if (section == null) {
            if (classname.equals("My Items")) {
                ArenaClass.MyItems myItems = new ArenaClass.MyItems(null, false, false, this);
                this.classes.put(lowercase, myItems);
                return myItems;
            }
            this.plugin.getLogger().severe("Failed to load class '" + classname + "'.");
            return null;
        }
        boolean weps = section.getBoolean("unbreakable-weapons", true);
        boolean arms = section.getBoolean("unbreakable-armor", true);
        Thing price = null;
        String priceString = section.getString("price", null);
        if (priceString != null) {
            try {
                price = this.plugin.getThingManager().parse(priceString);
            }
            catch (InvalidThingInputString e) {
                throw new ConfigError("Failed to parse price of class " + classname + ": " + e.getInput());
            }
        }
        ArenaClass arenaClass = classname.equals("My Items") ? new ArenaClass.MyItems(price, weps, arms, this) : new ArenaClass(classname, price, weps, arms);
        this.loadClassItems(section, arenaClass);
        this.loadClassArmor(section, arenaClass);
        this.loadClassPotionEffects(section, arenaClass);
        this.loadClassPermissions(arenaClass, section);
        this.loadClassLobbyPermissions(arenaClass, section);
        try {
            Location cc = ConfigUtils.parseLocation(section, "classchest", null);
            arenaClass.setClassChest(cc);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigError("Failed to parse classchest location for class " + classname + " because: " + e.getMessage());
        }
        this.classes.put(lowercase, arenaClass);
        return arenaClass;
    }

    private void loadClassItems(ConfigurationSection section, ArenaClass arenaClass) {
        List<String> items = section.getStringList("items");
        if (items == null || items.isEmpty()) {
            String value = section.getString("items", null);
            if (value == null || value.isEmpty()) {
                return;
            }
            items = Arrays.asList(value.split(","));
        }
        try {
            List<Thing> things = items.stream().map(String::trim).map(this.plugin.getThingManager()::parse).collect(Collectors.toList());
            arenaClass.setItems(things);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse item for class " + arenaClass.getConfigName() + ": " + e.getInput());
        }
    }

    private void loadClassArmor(ConfigurationSection section, ArenaClass arenaClass) {
        this.loadClassArmorLegacyNode(section, arenaClass);
        String name = arenaClass.getConfigName();
        this.loadClassArmorPiece(section, "helmet", name, arenaClass::setHelmet);
        this.loadClassArmorPiece(section, "chestplate", name, arenaClass::setChestplate);
        this.loadClassArmorPiece(section, "leggings", name, arenaClass::setLeggings);
        this.loadClassArmorPiece(section, "boots", name, arenaClass::setBoots);
        this.loadClassArmorPiece(section, "offhand", name, arenaClass::setOffHand);
    }

    private void loadClassArmorLegacyNode(ConfigurationSection section, ArenaClass arenaClass) {
        List<String> armor = section.getStringList("armor");
        if (armor == null || armor.isEmpty()) {
            String value = section.getString("armor", null);
            if (value == null || value.isEmpty()) {
                return;
            }
            armor = Arrays.asList(value.split(","));
        }
        try {
            List<Thing> things = armor.stream().map(String::trim).map(s -> this.plugin.getThingManager().parse("armor", (String)s)).collect(Collectors.toList());
            arenaClass.setArmor(things);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse armor for class " + arenaClass.getConfigName() + ": " + e.getInput());
        }
    }

    private void loadClassArmorPiece(ConfigurationSection section, String slot, String name, Consumer<Thing> setter) {
        String value = section.getString(slot, null);
        if (value == null) {
            return;
        }
        try {
            Thing thing = this.plugin.getThingManager().parse(slot, value);
            setter.accept(thing);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse " + slot + " slot for class " + name + ": " + e.getInput());
        }
    }

    private void loadClassPotionEffects(ConfigurationSection section, ArenaClass arenaClass) {
        List<String> effects = section.getStringList("effects");
        if (effects == null || effects.isEmpty()) {
            String value = section.getString("effects", null);
            if (value == null || value.isEmpty()) {
                return;
            }
            effects = Arrays.asList(value.split(","));
        }
        try {
            List<Thing> things = effects.stream().map(String::trim).map(s -> this.plugin.getThingManager().parse("effect", (String)s)).collect(Collectors.toList());
            arenaClass.setEffects(things);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse potion effect of class " + arenaClass.getConfigName() + ": " + e.getInput());
        }
    }

    private void loadClassPermissions(ArenaClass arenaClass, ConfigurationSection section) {
        try {
            section.getStringList("permissions").stream().map(s -> this.plugin.getThingManager().parse("perm", (String)s)).forEach(arenaClass::addPermission);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse permission of class " + arenaClass.getConfigName() + ": " + e.getInput());
        }
    }

    private void loadClassLobbyPermissions(ArenaClass arenaClass, ConfigurationSection section) {
        try {
            section.getStringList("lobby-permissions").stream().map(s -> this.plugin.getThingManager().parse("perm", (String)s)).forEach(arenaClass::addLobbyPermission);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse lobby-permission of class " + arenaClass.getConfigName() + ": " + e.getInput());
        }
    }

    @Override
    public void loadArenas() {
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection section = ConfigUtils.makeSection((ConfigurationSection)config, "arenas");
        Set arenanames = section.getKeys(false);
        if (arenanames == null || arenanames.isEmpty()) {
            this.createArenaNode(section, "default", (World)this.plugin.getServer().getWorlds().get(0), false);
        }
        this.arenas = new ArrayList<Arena>();
        for (World w : Bukkit.getServer().getWorlds()) {
            this.loadArenasInWorld(w.getName());
        }
    }

    @Override
    public void loadArenasInWorld(String worldName) {
        FileConfiguration config = this.plugin.getConfig();
        Set arenaNames = config.getConfigurationSection("arenas").getKeys(false);
        if (arenaNames == null || arenaNames.isEmpty()) {
            return;
        }
        ArrayList<Arena> arenas = new ArrayList<Arena>();
        for (String arenaName : arenaNames) {
            Arena loaded;
            String arenaWorld;
            Arena arena = this.getArenaWithName(arenaName);
            if (arena != null || !(arenaWorld = config.getString("arenas." + arenaName + ".settings.world", "")).equals(worldName) || (loaded = this.loadArena(arenaName)) == null) continue;
            arenas.add(loaded);
        }
        this.reportOverlappingRegions(arenas);
    }

    private void reportOverlappingRegions(List<Arena> arenas) {
        for (int i = 0; i < arenas.size(); ++i) {
            Arena a = arenas.get(i);
            for (int j = i + 1; j < arenas.size(); ++j) {
                Arena b = arenas.get(j);
                if (!a.getRegion().intersects(b.getRegion())) continue;
                this.plugin.getLogger().warning(String.format("Regions of arenas '%s' and '%s' overlap!", a.configName(), b.configName()));
            }
        }
    }

    @Override
    public void unloadArenasInWorld(String worldName) {
        FileConfiguration config = this.plugin.getConfig();
        Set arenaNames = config.getConfigurationSection("arenas").getKeys(false);
        if (arenaNames == null || arenaNames.isEmpty()) {
            return;
        }
        for (String arenaName : arenaNames) {
            String arenaWorld;
            Arena arena = this.getArenaWithName(arenaName);
            if (arena == null || !(arenaWorld = arena.getWorld().getName()).equals(worldName)) continue;
            arena.forceEnd();
            this.arenas.remove(arena);
        }
    }

    private Arena loadArena(String arenaname) {
        World world;
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection section = ConfigUtils.makeSection((ConfigurationSection)config, "arenas." + arenaname);
        ConfigurationSection settings = ConfigUtils.makeSection(section, "settings");
        String worldName = settings.getString("world", "");
        if (!worldName.equals("")) {
            world = this.plugin.getServer().getWorld(worldName);
            if (world == null) {
                this.plugin.getLogger().warning("World '" + worldName + "' for arena '" + arenaname + "' was not found...");
                return null;
            }
        } else {
            world = (World)this.plugin.getServer().getWorlds().get(0);
            this.plugin.getLogger().warning("Could not find the world for arena '" + arenaname + "'. Using default world ('" + world.getName() + "')! Check the config-file!");
        }
        ConfigUtils.addMissingRemoveObsolete((Plugin)this.plugin, "settings.yml", settings);
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "waves.yml", ConfigUtils.makeSection(section, "waves"));
        ArenaImpl arena = new ArenaImpl(this.plugin, section, arenaname, world);
        this.arenas.add(arena);
        this.plugin.getLogger().info("Loaded arena '" + arenaname + "'");
        return arena;
    }

    @Override
    public boolean reloadArena(String name) {
        Arena arena = this.getArenaWithName(name);
        if (arena == null) {
            return false;
        }
        arena.forceEnd();
        this.arenas.remove(arena);
        this.plugin.reloadConfig();
        this.loadArena(name);
        return true;
    }

    @Override
    public Arena createArenaNode(String arenaName, World world) {
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection section = ConfigUtils.makeSection((ConfigurationSection)config, "arenas");
        return this.createArenaNode(section, arenaName, world, true);
    }

    private Arena createArenaNode(ConfigurationSection arenas, String arenaName, World world, boolean load) {
        if (arenas.contains(arenaName)) {
            throw new IllegalArgumentException("Arena already exists!");
        }
        ConfigurationSection section = ConfigUtils.makeSection(arenas, arenaName);
        ConfigUtils.addMissingRemoveObsolete((Plugin)this.plugin, "settings.yml", ConfigUtils.makeSection(section, "settings"));
        section.set("settings.world", (Object)world.getName());
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "waves.yml", ConfigUtils.makeSection(section, "waves"));
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "rewards.yml", ConfigUtils.makeSection(section, "rewards"));
        this.plugin.saveConfig();
        return load ? this.loadArena(arenaName) : null;
    }

    @Override
    public void removeArenaNode(Arena arena) {
        this.arenas.remove(arena);
        FileConfiguration config = this.plugin.getConfig();
        config.set("arenas." + arena.configName(), null);
        this.plugin.saveConfig();
    }

    @Override
    public SpawnsPets getSpawnsPets() {
        return this.spawnsPets;
    }

    @Override
    public void reloadConfig() {
        this.plugin.reload();
    }

    @Override
    public void saveConfig() {
        this.plugin.saveConfig();
    }
}

