/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.ArenaPlayerStatistics;
import com.garbagemule.MobArena.ClassLimitManager;
import com.garbagemule.MobArena.MAUtils;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.MonsterManager;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.events.ArenaKillEvent;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.leaderboards.Leaderboard;
import com.garbagemule.MobArena.listeners.MAGlobalListener;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.region.RegionPoint;
import com.garbagemule.MobArena.repairable.RepairableAttachable;
import com.garbagemule.MobArena.repairable.RepairableBed;
import com.garbagemule.MobArena.repairable.RepairableBlock;
import com.garbagemule.MobArena.repairable.RepairableContainer;
import com.garbagemule.MobArena.repairable.RepairableDoor;
import com.garbagemule.MobArena.repairable.RepairableSign;
import com.garbagemule.MobArena.things.ExperienceThing;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.util.ClassChests;
import com.garbagemule.MobArena.waves.MABoss;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Attachable;
import org.bukkit.material.Bed;
import org.bukkit.material.Door;
import org.bukkit.material.Redstone;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class ArenaListener {
    private MobArena plugin;
    private Arena arena;
    private ArenaRegion region;
    private MonsterManager monsters;
    private ClassLimitManager classLimits;
    private boolean softRestore;
    private boolean softRestoreDrops;
    private boolean protect;
    private boolean monsterExp;
    private boolean monsterInfight;
    private boolean pvpOn;
    private boolean pvpEnabled = false;
    private boolean foodRegen;
    private boolean lockFoodLevel;
    private boolean useClassChests;
    private boolean allowTeleport;
    private boolean canShare;
    private boolean autoIgniteTNT;
    private Set<Player> banned;

    public ArenaListener(Arena arena, MobArena plugin) {
        this.plugin = plugin;
        this.arena = arena;
        this.region = arena.getRegion();
        this.monsters = arena.getMonsterManager();
        ConfigurationSection s = arena.getSettings();
        this.softRestore = s.getBoolean("soft-restore", false);
        this.softRestoreDrops = s.getBoolean("soft-restore-drops", false);
        this.protect = s.getBoolean("protect", true);
        this.monsterExp = s.getBoolean("monster-exp", false);
        this.monsterInfight = s.getBoolean("monster-infight", false);
        this.pvpOn = s.getBoolean("pvp-enabled", false);
        this.foodRegen = s.getBoolean("food-regen", false);
        this.lockFoodLevel = s.getBoolean("lock-food-level", true);
        this.allowTeleport = s.getBoolean("allow-teleporting", false);
        this.canShare = s.getBoolean("share-items-in-arena", true);
        this.autoIgniteTNT = s.getBoolean("auto-ignite-tnt", false);
        this.useClassChests = s.getBoolean("use-class-chests", false);
        this.classLimits = arena.getClassLimitManager();
        this.banned = new HashSet<Player>();
    }

    void pvpActivate() {
        if (this.arena.isRunning() && !this.arena.getPlayersInArena().isEmpty()) {
            this.pvpEnabled = this.pvpOn;
        }
    }

    void pvpDeactivate() {
        if (this.pvpOn) {
            this.pvpEnabled = false;
        }
    }

    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock() instanceof Sign && event.getBlock().getLocation().equals((Object)this.arena.getRegion().getLeaderboard())) {
            this.arena.getRegion().set("leaderboard", null);
        }
        if (!this.protect) {
            return;
        }
        if (!this.arena.getRegion().contains(event.getBlock().getLocation())) {
            return;
        }
        if (!this.arena.inArena(event.getPlayer())) {
            if (this.arena.inEditMode()) {
                return;
            }
            event.setCancelled(true);
        }
        if (this.onBlockDestroy((BlockEvent)event)) {
            return;
        }
        event.setCancelled(true);
    }

    public void onHangingBreak(HangingBreakEvent event) {
        if (!this.protect) {
            return;
        }
        Location l = event.getEntity().getLocation();
        if (!this.arena.getRegion().contains(l)) {
            return;
        }
        if (this.arena.inEditMode()) {
            return;
        }
        event.setCancelled(true);
    }

    public void onBlockBurn(BlockBurnEvent event) {
        if (!this.protect) {
            return;
        }
        if (!this.arena.getRegion().contains(event.getBlock().getLocation()) || this.onBlockDestroy((BlockEvent)event)) {
            return;
        }
        event.setCancelled(true);
    }

    private boolean onBlockDestroy(BlockEvent event) {
        if (this.arena.inEditMode()) {
            return true;
        }
        if (!this.arena.isRunning()) {
            return false;
        }
        Block b = event.getBlock();
        if (this.arena.removeBlock(b) || b.getType() == Material.TNT) {
            return true;
        }
        if (this.softRestore) {
            if (this.arena.isProtected()) {
                return false;
            }
            BlockState state = b.getState();
            RepairableBlock r = null;
            r = state instanceof InventoryHolder ? new RepairableContainer(state) : (state instanceof Sign ? new RepairableSign(state) : (state.getData() instanceof Attachable ? new RepairableAttachable(state) : new RepairableBlock(state)));
            this.arena.addRepairable(r);
            if (!this.softRestoreDrops) {
                b.setType(Material.AIR);
            }
            return true;
        }
        return false;
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        Block b = event.getBlock();
        if (!this.arena.getRegion().contains(b.getLocation()) || this.arena.inEditMode()) {
            return;
        }
        if (!this.arena.isRunning() || !this.arena.inArena(event.getPlayer())) {
            if (this.protect) {
                event.setCancelled(true);
            }
            return;
        }
        if (b.getType() == Material.TNT) {
            if (this.autoIgniteTNT) {
                event.setCancelled(true);
                ItemStack stack = event.getItemInHand();
                if (stack == null || stack.getType() != Material.TNT) {
                    this.plugin.getLogger().warning("Player " + event.getPlayer().getDisplayName() + " just placed TNT without holding a TNT block");
                    return;
                }
                stack.setAmount(stack.getAmount() - 1);
                TNTPrimed tnt = (TNTPrimed)b.getWorld().spawn(b.getRelative(BlockFace.UP).getLocation(), TNTPrimed.class);
                this.setPlanter((Metadatable)tnt, event.getPlayer());
                return;
            }
            this.setPlanter((Metadatable)b, event.getPlayer());
        }
        if (!this.protect) {
            return;
        }
        this.arena.addBlock(b);
        if (b.getType().name().endsWith("_DOOR")) {
            this.arena.addBlock(b.getRelative(0, 1, 0));
        }
    }

    private void setPlanter(Metadatable tnt, Player planter) {
        tnt.setMetadata("mobarena-planter", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)planter));
    }

    private Player getPlanter(Metadatable tnt) {
        List values = tnt.getMetadata("mobarena-planter");
        for (MetadataValue value : values) {
            if (!value.getOwningPlugin().equals((Object)this.plugin)) continue;
            return (Player)value.value();
        }
        return null;
    }

    public void onBlockForm(BlockFormEvent event) {
        if (!this.protect) {
            return;
        }
        if (!this.arena.getRegion().contains(event.getBlock().getLocation())) {
            return;
        }
        if (event.getNewState().getType() == Material.SNOW) {
            this.arena.addBlock(event.getBlock());
        }
    }

    public void onBlockFade(BlockFadeEvent event) {
        if (!this.protect) {
            return;
        }
        if (!this.arena.getRegion().contains(event.getBlock().getLocation())) {
            return;
        }
        switch (event.getBlock().getType()) {
            case ICE: 
            case SNOW: {
                event.setCancelled(true);
            }
        }
    }

    public void onBlockIgnite(BlockIgniteEvent event) {
        if (!this.protect) {
            return;
        }
        Block b = event.getBlock();
        if (!this.arena.getRegion().contains(b.getLocation())) {
            return;
        }
        switch (event.getCause()) {
            case FLINT_AND_STEEL: {
                if (this.arena.inEditMode()) {
                    return;
                }
                if (this.arena.isRunning()) {
                    if (b.getType() == Material.TNT) {
                        Player planter = this.getPlanter((Metadatable)b);
                        if (planter == null) break;
                        b.setType(Material.AIR);
                        TNTPrimed tnt = (TNTPrimed)b.getWorld().spawn(b.getLocation(), TNTPrimed.class);
                        this.setPlanter((Metadatable)tnt, planter);
                        break;
                    }
                    this.arena.addBlock(event.getBlock().getRelative(BlockFace.UP));
                    break;
                }
            }
            case LIGHTNING: 
            case SPREAD: 
            case FIREBALL: 
            case EXPLOSION: 
            case LAVA: {
                event.setCancelled(true);
            }
        }
    }

    public void onSignChange(SignChangeEvent event) {
        this.arena.setLeaderboard(new Leaderboard(this.plugin, this.arena, event.getBlock().getLocation()));
        this.arena.getRegion().set(RegionPoint.LEADERBOARD, event.getBlock().getLocation());
        this.arena.getPlugin().getGlobalMessenger().tell((CommandSender)event.getPlayer(), "Leaderboard made. Now set up the stat signs!");
    }

    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (!this.arena.getRegion().contains(event.getLocation())) {
            return;
        }
        if (this.arena.inEditMode() && event.getEntityType() == EntityType.ARMOR_STAND) {
            return;
        }
        if (!this.arena.isRunning()) {
            event.setCancelled(true);
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (reason == CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM || reason == CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN) {
            event.setCancelled(false);
            this.monsters.addGolem(event.getEntity());
            return;
        }
        if (reason == CreatureSpawnEvent.SpawnReason.DEFAULT) {
            if (event.getEntityType() == EntityType.VEX) {
                event.setCancelled(false);
                this.monsters.addMonster(event.getEntity());
            } else {
                event.setCancelled(true);
            }
            return;
        }
        if (reason != CreatureSpawnEvent.SpawnReason.CUSTOM) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(false);
        LivingEntity entity = event.getEntity();
        if (entity instanceof Slime) {
            this.monsters.addMonster(entity);
        }
    }

    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.monsters.getMonsters().contains(event.getEntity()) && !this.arena.getRegion().contains(event.getLocation(), 10)) {
            return;
        }
        this.monsters.remove(event.getEntity());
        if (!this.arena.isRunning()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(false);
        if (!this.softRestore && this.protect) {
            LinkedList<Block> blocks = new LinkedList<Block>(this.arena.getBlocks());
            event.blockList().retainAll(blocks);
            return;
        }
        if (!this.softRestoreDrops) {
            event.setYield(0.0f);
        }
        for (Block b : event.blockList()) {
            BlockState state = b.getState();
            if (state.getData() instanceof Door && ((Door)state.getData()).isTopHalf()) {
                state = b.getRelative(BlockFace.DOWN).getState();
            } else if (state.getData() instanceof Bed && ((Bed)state.getData()).isHeadOfBed()) {
                state = b.getRelative(((Bed)state.getData()).getFacing().getOppositeFace()).getState();
            }
            RepairableBlock r = null;
            r = state instanceof InventoryHolder ? new RepairableContainer(state) : (state instanceof Sign ? new RepairableSign(state) : (state.getData() instanceof Bed ? new RepairableBed(state) : (state.getData() instanceof Door ? new RepairableDoor(state) : (state.getData() instanceof Attachable || state.getData() instanceof Redstone ? new RepairableAttachable(state) : new RepairableBlock(state)))));
            Material mat = state.getType();
            if (mat == Material.CAKE || mat == Material.WATER || mat == Material.LAVA) {
                this.arena.removeBlock(b);
                continue;
            }
            if (this.arena.removeBlock(b)) {
                this.arena.getWorld().dropItemNaturally(b.getLocation(), new ItemStack(state.getType(), 1));
                continue;
            }
            if (this.softRestore) {
                this.arena.addRepairable(r);
                continue;
            }
            this.arena.queueRepairable(r);
        }
    }

    public void onEntityDeath(EntityDeathEvent event) {
        if (event instanceof PlayerDeathEvent) {
            this.onPlayerDeath((PlayerDeathEvent)event, (Player)event.getEntity());
        } else if (this.monsters.hasPet((Entity)event.getEntity())) {
            this.monsters.removePet((Entity)event.getEntity());
        } else if (this.monsters.removeMonster((Entity)event.getEntity())) {
            this.onMonsterDeath(event);
        } else if (this.monsters.removeMount((Entity)event.getEntity())) {
            this.onMountDeath(event);
        } else if (this.monsters.removeGolem(event.getEntity())) {
            this.arena.announce(Msg.GOLEM_DIED);
        }
    }

    private void onPlayerDeath(PlayerDeathEvent event, Player player) {
        if (this.arena.inArena(player) || this.arena.inLobby(player)) {
            event.getDrops().clear();
            event.setDroppedExp(0);
            event.setKeepLevel(true);
            if (player.getKiller() != null) {
                this.callKillEvent(player.getKiller(), (Entity)player);
            }
            if (this.arena.getSettings().getBoolean("show-death-messages", true)) {
                this.arena.announce(event.getDeathMessage());
            }
            if (this.arena.getSettings().getBoolean("keep-exp", false)) {
                this.arena.getRewardManager().addReward(player, new ExperienceThing(player.getTotalExperience()));
            }
            event.setDeathMessage(null);
            this.arena.getScoreboard().death(player);
            this.arena.playerDeath(player);
        } else if (this.arena.inSpec(player)) {
            event.getDrops().clear();
            event.setDroppedExp(0);
            this.arena.getScoreboard().death(player);
            this.arena.playerLeave(player);
        }
    }

    public boolean onPlayerRespawn(PlayerRespawnEvent event) {
        Player p = event.getPlayer();
        if (!this.arena.isDead(p)) {
            return false;
        }
        Location loc = this.arena.getRespawnLocation(p);
        event.setRespawnLocation(loc);
        this.arena.playerRespawn(p);
        return true;
    }

    private void onMountDeath(EntityDeathEvent event) {
    }

    private void onMonsterDeath(EntityDeathEvent event) {
        List<ItemStack> loot;
        EntityDamageEvent e1 = event.getEntity().getLastDamageCause();
        EntityDamageByEntityEvent e2 = e1 instanceof EntityDamageByEntityEvent ? (EntityDamageByEntityEvent)e1 : null;
        Entity damager = e2 != null ? e2.getDamager() : null;
        LivingEntity damagee = event.getEntity();
        if (damager instanceof Projectile) {
            ProjectileSource shooter = ((Projectile)damager).getShooter();
            if (shooter instanceof Entity) {
                damager = (Entity)shooter;
            }
        } else {
            Player owner = this.arena.getMonsterManager().getOwner(damager);
            if (owner != null) {
                damager = owner;
            }
        }
        if (damager instanceof Player) {
            Player p = (Player)damager;
            ArenaPlayer ap = this.arena.getArenaPlayer(p);
            if (ap != null) {
                MABoss boss;
                ArenaPlayerStatistics stats = ap.getStats();
                if (stats != null) {
                    ap.getStats().inc("kills");
                    this.arena.getScoreboard().addKill(p);
                }
                if ((boss = this.monsters.getBoss(damagee)) != null) {
                    for (Player q : this.arena.getPlayersInArena()) {
                        this.arena.getMessenger().tell((CommandSender)q, Msg.WAVE_BOSS_KILLED, p.getName());
                    }
                    Thing reward = boss.getReward();
                    if (reward != null) {
                        this.arena.getRewardManager().addReward(p, reward);
                        this.arena.getMessenger().tell((CommandSender)damager, Msg.WAVE_BOSS_REWARD_EARNED, reward.toString());
                    }
                }
            }
            this.callKillEvent(p, (Entity)damagee);
        }
        if (!this.monsterExp) {
            event.setDroppedExp(0);
        }
        event.getDrops().clear();
        MABoss boss = this.monsters.removeBoss(damagee);
        if (boss != null) {
            List<ItemStack> drops = boss.getDrops();
            if (drops != null && !drops.isEmpty()) {
                event.getDrops().addAll(drops);
            }
            boss.setDead(true);
            boss.getHealthBar().setProgress(0.0);
        }
        if ((loot = this.monsters.getLoot((Entity)damagee)) != null && !loot.isEmpty()) {
            event.getDrops().add(this.getRandomItem(loot));
        }
    }

    private void callKillEvent(Player killer, Entity victim) {
        ArenaKillEvent event = new ArenaKillEvent(this.arena, killer, victim);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
    }

    private ItemStack getRandomItem(List<ItemStack> stacks) {
        return stacks.get(new Random().nextInt(stacks.size()));
    }

    public void onEntityDamage(EntityDamageEvent event) {
        MABoss boss;
        Entity damagee = event.getEntity();
        EntityDamageByEntityEvent edbe = event instanceof EntityDamageByEntityEvent ? (EntityDamageByEntityEvent)event : null;
        Entity damager = null;
        if (edbe != null) {
            ProjectileSource shooter;
            damager = edbe.getDamager();
            if (damager instanceof Projectile && (shooter = ((Projectile)damager).getShooter()) instanceof Entity) {
                damager = (Entity)shooter;
            }
            if (damager instanceof TNTPrimed) {
                damager = this.getPlanter((Metadatable)damager);
            }
        }
        MABoss mABoss = boss = damagee instanceof LivingEntity ? this.monsters.getBoss((LivingEntity)damagee) : null;
        if (this.arena.hasPet(damagee)) {
            this.onPetDamage(event, damagee, damager);
        } else if (damagee instanceof ArmorStand) {
            this.onArmorStandDamage(event);
        } else if (damagee instanceof AbstractHorse && this.monsters.hasMount(damagee)) {
            this.onMountDamage(event, (Horse)damagee, damager);
        } else if (damagee instanceof Player) {
            this.onPlayerDamage(event, (Player)damagee, damager);
        } else if (damagee instanceof Snowman && event.getCause() == EntityDamageEvent.DamageCause.MELTING) {
            if (this.arena.isRunning() && this.arena.getRegion().contains(damagee.getLocation())) {
                event.setCancelled(true);
            }
        } else if (boss != null) {
            this.onBossDamage(event, boss, damager);
        } else if (this.monsters.getMonsters().contains(damagee)) {
            this.onMonsterDamage(event, damagee, damager);
        } else if (this.monsters.getGolems().contains(damagee)) {
            this.onGolemDamage(event, damagee, damager);
        }
    }

    private void onPlayerDamage(EntityDamageEvent event, Player player, Entity damager) {
        if (this.arena.inLobby(player) || this.arena.inSpec(player)) {
            event.setCancelled(true);
            return;
        }
        if (this.arena.inArena(player)) {
            if (!this.pvpEnabled && damager instanceof Player && !damager.equals(player)) {
                event.setCancelled(true);
                return;
            }
            event.setCancelled(false);
            this.arena.getArenaPlayer(player).getStats().add("dmgTaken", event.getDamage());
            if (damager instanceof LivingEntity && !(damager instanceof Player)) {
                LivingEntity target = (LivingEntity)damager;
                this.monsters.getPets(player).forEach(pet -> {
                    Mob mob;
                    if (pet instanceof Mob && (mob = (Mob)pet).getTarget() == null) {
                        mob.setTarget(target);
                    }
                });
            }
        }
    }

    private void onPetDamage(EntityDamageEvent event, Entity pet, Entity damager) {
        event.setCancelled(true);
    }

    private void onArmorStandDamage(EntityDamageEvent event) {
        if (this.protect && !this.arena.inEditMode() && this.region.contains(event.getEntity().getLocation())) {
            event.setCancelled(true);
        }
    }

    private void onMountDamage(EntityDamageEvent event, Horse mount, Entity damager) {
        event.setCancelled(true);
    }

    private void onBossDamage(EntityDamageEvent event, MABoss boss, Entity damager) {
        this.onMonsterDamage(event, (Entity)boss.getEntity(), damager);
        if (event.isCancelled()) {
            return;
        }
        double progress = boss.getHealth() / boss.getMaxHealth();
        boss.getHealthBar().setProgress(progress);
    }

    private void onMonsterDamage(EntityDamageEvent event, Entity monster, Entity damager) {
        if (damager instanceof Player) {
            Player p = (Player)damager;
            if (!this.arena.inArena(p)) {
                event.setCancelled(true);
                return;
            }
            ArenaPlayerStatistics aps = this.arena.getArenaPlayer(p).getStats();
            aps.add("dmgDone", event.getDamage());
            aps.inc("hits");
        } else if (this.arena.hasPet(damager)) {
            Player owner = this.arena.getMonsterManager().getOwner(damager);
            if (owner != null) {
                ArenaPlayerStatistics aps = this.arena.getArenaPlayer(owner).getStats();
                aps.add("dmgDone", event.getDamage());
            }
        } else if (this.monsters.getMonsters().contains(damager) && !this.monsterInfight) {
            event.setCancelled(true);
        }
    }

    private void onGolemDamage(EntityDamageEvent event, Entity golem, Entity damager) {
        if (damager instanceof Player) {
            Player p = (Player)damager;
            if (!this.arena.inArena(p)) {
                event.setCancelled(true);
                return;
            }
            if (!this.pvpEnabled) {
                event.setCancelled(true);
            }
        }
    }

    public void onEntityCombust(EntityCombustEvent event) {
        if (this.monsters.getMonsters().contains(event.getEntity())) {
            if (event instanceof EntityCombustByBlockEvent || event instanceof EntityCombustByEntityEvent) {
                return;
            }
            event.setCancelled(true);
        }
    }

    public void onEntityTarget(EntityTargetEvent event) {
        if (!this.arena.isRunning() || event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        Entity target = event.getTarget();
        if (this.isArenaPet(entity)) {
            this.onPetTarget(event, target);
        } else if (this.isArenaMonster(entity)) {
            this.onMonsterTarget(event, entity, target);
        } else {
            this.onForeignTarget(event, target);
        }
    }

    private void onPetTarget(EntityTargetEvent event, Entity target) {
        if (target == null) {
            return;
        }
        if (!this.isArenaMonster(target)) {
            event.setCancelled(true);
        }
    }

    private void onMonsterTarget(EntityTargetEvent event, Entity monster, Entity target) {
        if (target == null) {
            event.setTarget((Entity)MAUtils.getClosestPlayer(this.plugin, monster, this.arena));
            return;
        }
        if (this.monsterInfight && this.isArenaMonster(target)) {
            return;
        }
        if (!this.isArenaPlayer(target)) {
            event.setCancelled(true);
        }
    }

    private void onForeignTarget(EntityTargetEvent event, Entity target) {
        if (target == null) {
            return;
        }
        if (this.isArenaPet(target) || this.isArenaPlayer(target) || this.isArenaMonster(target)) {
            event.setCancelled(true);
        }
    }

    private boolean isArenaPlayer(Entity entity) {
        return this.arena.getPlayersInArena().contains(entity);
    }

    private boolean isArenaMonster(Entity entity) {
        return this.monsters.getMonsters().contains(entity);
    }

    private boolean isArenaPet(Entity entity) {
        return this.arena.hasPet(entity);
    }

    public void onEntityTeleport(EntityTeleportEvent event) {
        if (this.monsters.hasPet(event.getEntity()) && this.region.contains(event.getTo())) {
            return;
        }
        if (this.region.contains(event.getFrom()) || this.region.contains(event.getTo())) {
            event.setCancelled(true);
        }
    }

    public void onPotionSplash(PotionSplashEvent event) {
        block6: {
            ThrownPotion potion;
            block7: {
                potion = event.getPotion();
                if (!this.region.contains(potion.getLocation())) {
                    return;
                }
                if (!(potion.getShooter() instanceof Player)) break block7;
                if (this.pvpEnabled) break block6;
                for (PotionEffect effect : potion.getEffects()) {
                    PotionEffectType type = effect.getType();
                    if (!type.equals((Object)PotionEffectType.HARM) && !type.equals((Object)PotionEffectType.POISON)) continue;
                    for (LivingEntity le : event.getAffectedEntities()) {
                        if (!(le instanceof Player)) continue;
                        event.setIntensity(le, 0.0);
                    }
                    break block6;
                }
                break block6;
            }
            if (!this.monsterInfight) {
                for (PotionEffect effect : potion.getEffects()) {
                    PotionEffectType type = effect.getType();
                    if (!type.equals((Object)PotionEffectType.HARM) && !type.equals((Object)PotionEffectType.POISON)) continue;
                    for (LivingEntity le : event.getAffectedEntities()) {
                        if (le instanceof Player) continue;
                        event.setIntensity(le, 0.0);
                    }
                    break;
                }
            }
        }
    }

    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (this.arena.getRegion().contains(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (!this.arena.isRunning()) {
            return;
        }
        if (!(event.getEntity() instanceof Player) || !this.arena.inArena((Player)event.getEntity())) {
            return;
        }
        if (!this.foodRegen && event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED) {
            event.setCancelled(true);
        }
    }

    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getEntity();
        if (this.arena.isRunning()) {
            if (this.arena.inArena(p) && this.lockFoodLevel) {
                event.setCancelled(true);
            }
        } else if (this.arena.inLobby(p) || this.arena.inSpec(p)) {
            event.setCancelled(true);
        }
    }

    public void onPlayerAnimation(PlayerAnimationEvent event) {
        if (!this.arena.isRunning() || !this.arena.inArena(event.getPlayer())) {
            return;
        }
        this.arena.getArenaPlayer(event.getPlayer()).getStats().inc("swings");
    }

    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player p = event.getPlayer();
        if (this.arena.isLeaving(p)) {
            return;
        }
        if (this.arena.inArena(p)) {
            if (!this.canShare) {
                this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_DROP_ITEM);
                event.setCancelled(true);
            }
        } else if (this.arena.inLobby(p)) {
            this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_DROP_ITEM);
            event.setCancelled(true);
        } else if (this.arena.inSpec(p)) {
            this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_DROP_ITEM);
            event.setCancelled(true);
            if (!this.region.contains(p.getLocation())) {
                this.arena.getMessenger().tell((CommandSender)p, Msg.MISC_MA_LEAVE_REMINDER);
                this.arena.playerLeave(p);
            }
        } else if (this.region.contains(p.getLocation())) {
            this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_DROP_ITEM);
            event.setCancelled(true);
        } else if (this.banned.contains(p)) {
            this.plugin.getLogger().warning("Player " + p.getName() + " tried to steal class items!");
            event.setCancelled(true);
        }
    }

    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (!this.arena.getReadyPlayersInLobby().contains(event.getPlayer()) && !this.arena.inArena(event.getPlayer())) {
            return;
        }
        if (!this.arena.isRunning()) {
            event.getBlockClicked().getRelative(event.getBlockFace()).setType(Material.AIR);
            event.setCancelled(true);
            return;
        }
        Block liquid = event.getBlockClicked().getRelative(event.getBlockFace());
        this.arena.addBlock(liquid);
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        if (!this.arena.inLobby(p)) {
            return;
        }
        if (event.hasItem()) {
            event.setUseItemInHand(Event.Result.DENY);
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND || !event.hasBlock()) {
            return;
        }
        if (event.getClickedBlock().getType() == Material.IRON_BLOCK) {
            this.handleReadyBlock(p);
        } else if (event.getClickedBlock().getState() instanceof Sign) {
            Sign sign = (Sign)event.getClickedBlock().getState();
            this.handleSign(sign, p);
        }
    }

    public void onPlayerArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        if (this.protect && !this.arena.inEditMode() && this.region.contains(event.getRightClicked().getLocation())) {
            event.setCancelled(true);
        }
    }

    private void handleReadyBlock(Player p) {
        if (this.arena.getArenaPlayer(p).getArenaClass() != null) {
            this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_PLAYER_READY);
            this.arena.playerReady(p);
        } else {
            this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_PICK_CLASS);
        }
    }

    private void handleSign(Sign sign, Player p) {
        String className = ChatColor.stripColor((String)sign.getLine(0)).toLowerCase().replace(" ", "");
        if (!this.arena.getClasses().containsKey(className) && !className.equals("random")) {
            return;
        }
        ArenaClass newAC = this.arena.getClasses().get(className);
        if (!newAC.hasPermission(p) && !className.equals("random")) {
            this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_PERMISSION);
            return;
        }
        ArenaClass oldAC = this.arena.getArenaPlayer(p).getArenaClass();
        if (newAC.equals(oldAC)) {
            return;
        }
        if (!this.classLimits.canPlayerJoinClass(newAC)) {
            this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_FULL);
            return;
        }
        Thing price = newAC.getPrice();
        if (price != null && !price.heldBy(p)) {
            this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_TOO_EXPENSIVE, price.toString());
            return;
        }
        this.classLimits.playerLeftClass(oldAC, p);
        this.classLimits.playerPickedClass(newAC, p);
        this.delayAssignClass(p, className, price, sign);
    }

    private void delayAssignClass(final Player p, final String className, final Thing price, final Sign sign) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!className.equalsIgnoreCase("random")) {
                    if (ArenaListener.this.useClassChests) {
                        ArenaClass ac = ArenaListener.this.plugin.getArenaMaster().getClasses().get(className.toLowerCase().replace(" ", ""));
                        if (ClassChests.assignClassFromStoredClassChest(ArenaListener.this.arena, p, ac)) {
                            return;
                        }
                        if (ClassChests.assignClassFromClassChestSearch(ArenaListener.this.arena, p, ac, sign)) {
                            return;
                        }
                    }
                    ArenaListener.this.arena.assignClass(p, className);
                    ArenaListener.this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_PICKED, ArenaListener.this.arena.getClasses().get(className).getConfigName());
                    if (price != null) {
                        ArenaListener.this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_PRICE, price.toString());
                    }
                } else {
                    ArenaListener.this.arena.addRandomPlayer(p);
                    ArenaListener.this.arena.getMessenger().tell((CommandSender)p, Msg.LOBBY_CLASS_RANDOM);
                }
            }
        });
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        Player p = event.getPlayer();
        if (!this.arena.isEnabled() || !this.arena.inArena(p) && !this.arena.inLobby(p) && !this.arena.inSpec(p)) {
            return;
        }
        this.arena.playerLeave(p);
        this.banned.add(p);
        this.scheduleUnban(p, 20);
    }

    public void onPlayerKick(PlayerKickEvent event) {
        Player p = event.getPlayer();
        if (!this.arena.isEnabled() || !this.arena.inArena(p) && !this.arena.inLobby(p) && !this.arena.inSpec(p)) {
            return;
        }
        this.arena.playerLeave(p);
        this.banned.add(p);
        this.scheduleUnban(p, 20);
    }

    private void scheduleUnban(final Player p, int ticks) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ArenaListener.this.banned.remove(p);
            }
        }, (long)ticks);
    }

    public MAGlobalListener.TeleportResponse onPlayerTeleport(PlayerTeleportEvent event) {
        if (!this.arena.isEnabled() || !this.region.isSetup() || this.arena.inEditMode() || this.allowTeleport) {
            return MAGlobalListener.TeleportResponse.IDGAF;
        }
        Player p = event.getPlayer();
        if (this.arena.isMoving(p)) {
            return MAGlobalListener.TeleportResponse.ALLOW;
        }
        Location to = event.getTo();
        Location from = event.getFrom();
        if (this.region.contains(from)) {
            if (this.region.contains(to)) {
                if (!this.arena.inArena(p) && !this.arena.inLobby(p)) {
                    this.arena.getMessenger().tell((CommandSender)p, Msg.WARP_TO_ARENA);
                    return MAGlobalListener.TeleportResponse.REJECT;
                }
                return MAGlobalListener.TeleportResponse.ALLOW;
            }
            if (this.arena.getAllPlayers().contains(p)) {
                this.arena.getMessenger().tell((CommandSender)p, Msg.WARP_FROM_ARENA);
                return MAGlobalListener.TeleportResponse.REJECT;
            }
            return MAGlobalListener.TeleportResponse.IDGAF;
        }
        if (this.region.contains(to)) {
            this.arena.getMessenger().tell((CommandSender)p, Msg.WARP_TO_ARENA);
            return MAGlobalListener.TeleportResponse.REJECT;
        }
        return MAGlobalListener.TeleportResponse.IDGAF;
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player p = event.getPlayer();
        if (event.isCancelled() || !this.arena.inArena(p) && !this.arena.inSpec(p) && !this.arena.inLobby(p)) {
            return;
        }
        String base = event.getMessage().split(" ")[0].toLowerCase();
        if (this.plugin.getArenaMaster().isAllowed(base)) {
            return;
        }
        String noslash = event.getMessage().substring(1).toLowerCase();
        if (this.plugin.getArenaMaster().isAllowed(noslash)) {
            return;
        }
        event.setMessage("/");
        event.setCancelled(true);
        this.arena.getMessenger().tell((CommandSender)p, Msg.MISC_COMMAND_NOT_ALLOWED);
    }

    public void onPlayerPreLogin(PlayerLoginEvent event) {
        Player p = event.getPlayer();
        if (p == null || !p.isOnline()) {
            return;
        }
        Arena arena = this.plugin.getArenaMaster().getArenaWithPlayer(p);
        if (arena == null) {
            return;
        }
        arena.playerLeave(p);
    }

    public void onVehicleEnter(VehicleEnterEvent event) {
        Entity entity = event.getEntered();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!this.arena.inArena(p)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Horse)) {
            return;
        }
        Horse horse = (Horse)vehicle;
        if (!this.monsters.hasMount((Entity)horse)) {
            return;
        }
        AnimalTamer tamer = horse.getOwner();
        if (tamer.equals(p)) {
            horse.setAI(true);
        } else {
            event.setCancelled(true);
        }
    }

    public void onVehicleExit(VehicleExitEvent event) {
        LivingEntity entity = event.getExited();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!this.arena.inArena(p)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Horse)) {
            return;
        }
        Horse horse = (Horse)vehicle;
        if (!this.monsters.hasMount((Entity)horse)) {
            return;
        }
        horse.setAI(false);
    }
}

