/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.things.Thing;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ArenaClass {
    private String configName;
    private String lowercaseName;
    private Thing helmet;
    private Thing chestplate;
    private Thing leggings;
    private Thing boots;
    private Thing offhand;
    private List<Thing> armor;
    private List<Thing> items;
    private List<Thing> effects;
    private List<Thing> perms;
    private List<Thing> lobbyperms;
    private boolean unbreakableWeapons;
    private boolean unbreakableArmor;
    private Thing price;
    private Location classchest;

    public ArenaClass(String name, Thing price, boolean unbreakableWeapons, boolean unbreakableArmor) {
        this.configName = name;
        this.lowercaseName = name.toLowerCase().replace(" ", "");
        this.items = new ArrayList<Thing>();
        this.armor = new ArrayList<Thing>(4);
        this.effects = new ArrayList<Thing>();
        this.perms = new ArrayList<Thing>();
        this.lobbyperms = new ArrayList<Thing>();
        this.unbreakableWeapons = unbreakableWeapons;
        this.unbreakableArmor = unbreakableArmor;
        this.price = price;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getLowercaseName() {
        return this.lowercaseName;
    }

    public void setHelmet(Thing helmet) {
        this.helmet = helmet;
    }

    public void setChestplate(Thing chestplate) {
        this.chestplate = chestplate;
    }

    public void setLeggings(Thing leggings) {
        this.leggings = leggings;
    }

    public void setBoots(Thing boots) {
        this.boots = boots;
    }

    public void setOffHand(Thing offhand) {
        this.offhand = offhand;
    }

    public void addItem(Thing item) {
        if (item != null) {
            this.items.add(item);
        }
    }

    public void setItems(List<Thing> items) {
        this.items = new ArrayList<Thing>(items.size());
        items.forEach(this::addItem);
    }

    public void setArmor(List<Thing> armor) {
        this.armor = armor;
    }

    public void setEffects(List<Thing> effects) {
        this.effects = effects;
    }

    public boolean hasPermission(Player p) {
        String perm = "mobarena.classes." + this.configName;
        return !p.isPermissionSet(perm) || p.hasPermission(perm);
    }

    public void grantItems(Player p) {
        PlayerInventory inv = p.getInventory();
        this.items.forEach(item -> item.giveTo(p));
        this.armor.forEach(thing -> thing.giveTo(p));
        if (this.helmet != null) {
            this.helmet.giveTo(p);
        }
        if (this.chestplate != null) {
            this.chestplate.giveTo(p);
        }
        if (this.leggings != null) {
            this.leggings.giveTo(p);
        }
        if (this.boots != null) {
            this.boots.giveTo(p);
        }
        if (this.offhand != null) {
            this.offhand.giveTo(p);
        }
    }

    public void grantPotionEffects(Player p) {
        this.effects.forEach(thing -> thing.giveTo(p));
    }

    public void addPermission(Thing permission) {
        this.perms.add(permission);
    }

    public void addLobbyPermission(Thing permission) {
        this.lobbyperms.add(permission);
    }

    public void grantPermissions(Player p) {
        this.perms.forEach(perm -> perm.giveTo(p));
    }

    public void grantLobbyPermissions(Player p) {
        this.lobbyperms.forEach(perm -> perm.giveTo(p));
    }

    public Location getClassChest() {
        return this.classchest;
    }

    public void setClassChest(Location loc) {
        this.classchest = loc;
    }

    public boolean hasUnbreakableWeapons() {
        return this.unbreakableWeapons;
    }

    public boolean hasUnbreakableArmor() {
        return this.unbreakableArmor;
    }

    public Thing getPrice() {
        return this.price;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ArenaClass other = (ArenaClass)o;
        return other.lowercaseName.equals(this.lowercaseName);
    }

    public int hashCode() {
        return this.lowercaseName.hashCode();
    }

    public static class MyItems
    extends ArenaClass {
        private ArenaMaster am;

        public MyItems(Thing price, boolean unbreakableWeapons, boolean unbreakableArmor, ArenaMaster am) {
            super("My Items", price, unbreakableWeapons, unbreakableArmor);
            this.am = am;
        }

        @Override
        public void grantItems(Player p) {
            Arena arena = this.am.getArenaWithPlayer(p);
            if (arena != null) {
                try {
                    arena.getInventoryManager().equip(p);
                    this.removeBannedItems(p.getInventory());
                }
                catch (Exception e) {
                    this.am.getPlugin().getLogger().severe("Failed to give " + p.getName() + " their own items: " + e.getMessage());
                }
            }
        }

        @Override
        public Location getClassChest() {
            return null;
        }

        private void removeBannedItems(PlayerInventory inv) {
            ItemStack[] contents = inv.getContents();
            IntStream.range(0, contents.length).filter(i -> contents[i] != null).filter(i -> this.isBanned(contents[i].getType())).forEach(arg_0 -> ((PlayerInventory)inv).clear(arg_0));
        }

        private boolean isBanned(Material type) {
            switch (type) {
                case ENDER_PEARL: 
                case ENDER_CHEST: 
                case SHULKER_SHELL: {
                    return true;
                }
            }
            return type.name().endsWith("_SHULKER_BOX");
        }
    }
}

